import os
import numpy as np
import reidlib.model as reidmodel
from helper import evaluate_clustering_result_infomap, evaluate_reid


# Specify the directory path of each dataset.
dataset2dir_path = {
    "market_train": "datasets/market1501/Market-1501-v15.09.15/bounding_box_train",
    "market_query": "datasets/market1501/Market-1501-v15.09.15/query",
    "market_test": "datasets/market1501/Market-1501-v15.09.15/bounding_box_test",
    
    "msmt_train": "datasets/msmt17/MSMT17_V1/bounding_box_train",
    "msmt_query": "datasets/msmt17/MSMT17_V1/query",
    "msmt_test": "datasets/msmt17/MSMT17_V1/bounding_box_test",

    "veri_train": "datasets/veri/VeRi/image_train",
    "veri_query": "datasets/veri/VeRi/image_query",
    "veri_test": "datasets/veri/VeRi/image_test",
    
    "cuhk_train": "datasets/cuhk03/bounding_box_train",
    "cuhk_query": "datasets/cuhk03/query",
    "cuhk_test": "datasets/cuhk03/bounding_box_test",

    "personx_train": "datasets/personx/PersonX/bounding_box_train",
    "personx_query": "datasets/personx/PersonX/query",
    "personx_test": "datasets/personx/PersonX/bounding_box_test",
}

# Specify the experiment configuration.
model_config = {
    "name": "pplr_msmt",  # Output directory name.
    "model_type": "pplr",   # Model types. The available model list can be found in reidlib/model/__init__.py
    "checkpoint_path": "weights/pplr_msmt.pth",
    "hw": (384, 128)
}
dataset_name = "cuhk"  # Dataset name to test. e.g., "market", "cuhk", "personx", "msmt".
batch_size = 256  # Batch size for inference.
epsilons = np.arange(0.20, 1.0, 0.01)  # Parameters of InfoMAP algorithm.
out_base_path = "outs/clustering_result_infomap"  # Output path.
out_dir_path = os.path.join(out_base_path, model_config["name"], dataset_name)

# Load the model.
model, preprocessor = reidmodel.load_model(model_config["model_type"],  model_config["checkpoint_path"], 
                                           h=model_config["hw"][0], w=model_config["hw"][1])


# Evaluate the ReID performance.
# - The results are printed.
evaluate_reid(dataset2dir_path, model, preprocessor, dataset_name, model_config["name"])

# Evaluate the camera bias and accuracy of the clusters.
# - The results with various epsilon values are saved at `out_dir_path`.
# - We report the bias and accuracy values of the result whose `inlier_ratio` is closest to 0.99 for fair comparison.
evaluate_clustering_result_infomap(dataset2dir_path, model, preprocessor, dataset_name, epsilons, out_dir_path)
