from .cc.helper import load_model_cc, load_preprocessor_cc
from .pplr.helper import load_model_pplr, load_preprocessor_pplr
from .transreid_ssl.helper import load_model_transreid_ssl, load_preprocessor_transreid_ssl
from .isr.helper import load_model_isr, load_preprocessor_isr
from .transreid.helper import load_model_transreid, load_preprocessor_transreid
from .solider.helper import load_model_solider, load_preprocessor_solider
from .spcl.helper import load_model_spcl, load_preprocessor_spcl
from .cap.helper import load_model_cap, load_preprocessor_cap
from .pat.helper import load_model_pat, load_preprocessor_pat


models = {
    "cc": (load_model_cc, load_preprocessor_cc),
    "pplr": (load_model_pplr, load_preprocessor_pplr),
    "transreid_ssl": (load_model_transreid_ssl, load_preprocessor_transreid_ssl),
    "isr": (load_model_isr, load_preprocessor_isr),
    "transreid": (load_model_transreid, load_preprocessor_transreid),
    "solider": (load_model_solider, load_preprocessor_solider),
    "spcl": (load_model_spcl, load_preprocessor_spcl),
    "cap": (load_model_cap, load_preprocessor_cap),
    "pat": (load_model_pat, load_preprocessor_pat),
}


def load_model(model_type, checkpoint_path, **kwargs):
    load_model, load_preprocessor = models[model_type]
    model = load_model(checkpoint_path)
    preprocessor = load_preprocessor(**kwargs)
    return model, preprocessor
