# SpikeGPT: Generative Pre-trained Language Model with Spiking Neural Networks


SpikeGPT is a lightweight generative language model with pure binary, event-driven spiking activation units. 

If you are interested in SpikeGPT, feel free to join our Discord using this [link](https://discord.gg/gdUpuTJ6QZ)!

This repo is inspired by the [RWKV-LM](https://github.com/BlinkDL/RWKV-LM).

## Training on Enwik8

1. Download the [enwik8 dataset](https://data.deepai.org/enwik8.zip).
2. Run `train.py`

## Inference with Prompt

You can choose to run inference with either your own customized model or with our pre-trained model. 

1. Modify the hyper-parameter of the network, which could be found in line 36-38 of the `run.py`:
```python
# For BookCorpus pre-trained model, you can change it if you trained your own model.
n_layer = 18
n_embd = 512
ctx_len = 1024
```
2. download our BookCorpus pre-trained model, and put it in the root directory of this repo.
3. Modify the  'context' variable in `run.py` to your custom prompt
4. Run `run.py`

##Fine-Tune with NLU tasks
1. run the file in 'NLU' folders
2. change the path in line 17 to the model path


