# This is official implementation of PITTA: Pose-Agnostic Instance-Aware Test-Time Adaptation for Monocular Depth Estimation
## Environment setting
```bash
conda create -n pitta python=3.10 -y
conda acitvate pitta
```

## Dependency
```bash
pip3 install torch==2.1.0 torchvision==0.16.0 --index-url https://download.pytorch.org/whl/cu118
pip3 install mmcv-full==1.7.2, mmsegmentation==0.29.1
pip3 install transformers, timm, matplotlib, opencv-python, scikit-image, scikit-image, einops, tensorboard
```

## Model weights
monodepth2: https://storage.googleapis.com/niantic-lon-static/research/monodepth2/mono_640x192.zip
model weights is found in the link above and save it `./weights` folder.
```
weights 
    |--- mono_640x192
                |---encoder.pth
                |---decoder.pth
```

## Prepare dataset
1. Download image and depth ground truth to './data/DrivingStereo':
- depth-map-full-size: https://drive.google.com/file/d/1hEV1YyEX6nMp9b8M3kZTqYmhAKvR7HLs/view?usp=drive_link
- left-image-full-size: https://drive.google.com/file/d/1hEV1YyEX6nMp9b8M3kZTqYmhAKvR7HLs/view?usp=drive_link

2. Unzip both data
```
tar -xvf ./data/DrivingStereo/depth-map-full-size.zip
tar -xvf ./data/DrivingStereo/left-image-full-size.zip
```

3. Extract depth ground truth
```bash
python3 export_gt_depth.py --data_path ./data/DrivingStereo --split rainy
```

## Run PITTA
```bash
sh exp.sh
```