import os
os.environ["MKL_NUM_THREADS"] = "1"  # noqa F402
os.environ["NUMEXPR_NUM_THREADS"] = "1"  # noqa F402
os.environ["OMP_NUM_THREADS"] = "1"  # noqa F402
import skimage.transform
import numpy as np
import PIL.Image as pil

from kitti_utils import generate_depth_map
from .mono_dataset import MonoDataset


class DRIVINGSTEREO(MonoDataset):
    """Superclass for different types of DrivingStereo dataset loader
    """
    def __init__(self, *args, **kwargs):
        super(DRIVINGSTEREO, self).__init__(*args, **kwargs)
        # self.K = np.array([[1.17, 0, 0.5, 0],
        #                 [0, 2.58, 0.5, 0],
        #                 [0, 0, 1, 0],
        #                 [0, 0, 0, 1]], dtype=np.float32)
        self.K = np.array([[ 1.19953488e+00, -2.90697674e-04,  5.68779070e-01, 0.],
                            [ 0.00000000e+00,  2.57800000e+00,  7.30875000e-01, 0.],
                            [ 0.00000000e+00,  0.00000000e+00,  1.00000000e+00, 0.],
                            [0., 0., 0., 1.]], dtype=np.float32)
    def get_color(self, line, stereo_split):
        color = self.loader(os.path.join(self.data_path, stereo_split, 'left-image-full-size', stereo_split, line))

        return color
    
    def __len__(self):
        if len(self.frame_idxs)==3:
            return len(self.filenames[1:-1])
        return len(self.filenames)

