clear all
close all
clc

%% second variation formula (formula 14)
variation = @(cc,ee,bb) -(2/3)*(3*bb*ee^4/10+(bb*cc^2-3)*ee^2-3*cc^2);


b = 2; %selecting beta
e = 1:0.001:(1.1*sqrt(10/b)); %epsilon variable


for c = 0.001:0.1:30 %c variable
    var_e = 0*e;
    for idx_e = 1:length(e)
        var_e(idx_e)=variation(c,e(idx_e),b);
    end
    plot(e,var_e,'linewidth',2,'color',[0.333 0.678 0.78]);hold on
end

%% plotting
plot([sqrt(10/b),sqrt(10/b)],[-10,10],'linewidth',2,'color',[0.845 0.477 0.199]);hold on
plot([sqrt(3/b),sqrt(3/b)],[-10,10],'linewidth',2,'color',[0.845 0.477 0.199]);hold on
plot(e,0*e,'--','linewidth',2,'color',[0.845 0.477 0.199]);hold on
ylim([-10,10])
tet=text(sqrt(3/b),6,'$\sqrt{\frac{3}{\beta}}$','fontsize',35,'interpreter','latex','color',[0.845 0.477 0.199],'fontweight', 'bold');
tet=text(sqrt(10/b),6,'$\sqrt{\frac{10}{\beta}}$','fontsize',35,'interpreter','latex','color',[0.845 0.477 0.199],'fontweight', 'bold');
xlabel('$\epsilon$','fontsize',25,'interpreter','latex')
title('$\delta^2J(h_{\epsilon,c})$ for $c\in(0,30)$, $\beta = 2$','fontsize',25,'interpreter','latex')
