module SNNT

ENV["PROTOCOL_BUFFERS_PYTHON_IMPLEMENTATION"]="python"

#Util
include("Util/Main.jl")
# Configuration
include("Config/Main.jl")

# Basic Definitions
include("AST/Main.jl")
include("VerifierInterface/Main.jl")

# Parsing
include("Parsing/Main.jl")

# Analysis
include("Analysis/Main.jl")

# Constraint Solvers
include("LP/Main.jl")
include("SMTInterface/Main.jl")

# Query Generation
include("QueryGeneration/Main.jl")

# Query Approximation
include("Approx/Main.jl")

# Verifier Integration
include("Verifiers/Main.jl")

# Bringing it all together
include("Control/Main.jl")

# Cmd Interface
include("Cmd/Main.jl")

using .AST
#export not, and, or, implies, <, <=, >, >=, ==, !=, +, -, *, /, ^
#export istree, exprhead, operation, arguments,similarterm, symtype, promote_symtype

using .Control
#export load_query, run_query, prepare_for_olnnv

using .Verifiers
#export VERIFIER_CALLBACKS

using .Cmd

export run_cmd

function main_NCubeV():Cint
    result = run_cmd(ARGS)
    return convert(Cint, result)
end

end # module
