## Setup
```bash
python -m venv .venv
source .venv/bin/activate
pip install -r requirements.txt
```

## Scripts

### Localization using Attention Contribution + Generation and CLIP Evaluation

Example:
```bash
python run_attn_cont_variant.py --results_path="your_desired_path" --disable_k_dominant_blocks=6 --num_workers=1 --worker_idx=0 --calc_attn_cont_fn_variant="m_mult_v_mult_o_normalized_by_out_norm"
```

Check out `localize_and_remove/run_parallel.ipynb` for more details.

### Generation of baselines (no style / full style) and CLIP Evaluation

**No Style:**
```bash
python no_style_gen_and_eval.py --results_path="your_desired_path"
```

**Full Style:**
```bash
python ground_truth_gen_and_eval.py --results_path="your_desired_path" --num_workers=1 --worker_idx=0
```

Increase the `--num_workers` parameter to a higher value `K`, then execute the script multiple times with `--worker_idx` ranging from `0` to `K-1`. This enables parallel processing, leading to faster generation and CLIP evaluation.

### CSD Evaluation

First clone the model checkpoint:

```bash
mkdir pretrained_models
gdown 1FX0xs8p-C7Ob-h5Y4cUhTeOepHzXv_46 -O "pretrained_models/csd_checkpoint.pth"
```

then for the evaluation:

```bash
python csd_calc.py --results_path="your_desired_path_containing_the_images" --artists_list_for_model="pixart" --eval_single_artist_directory
```

Remove `--eval_single_artist_directory` if you want to evaluate each artist's directory in the `results_path`


---

> **_NOTE:_** The dataset—particularly the safety category—includes prompts that may contain unsafe or harmful content.
