# Global optimization of graph acquisition functions for neural architecture search

Code implementation of NAS-GOAT, which is able to **g**lobally **o**ptimize graph **a**cquisi**t**ion functions based on a novel graph encoding for NAS through BO approach.

## Setup
Use the [requirements.txt](requirements.txt) file to set up python environment:
```commandline
pip install requirements.txt
```

## Dataset
Download the publicly available datasets for NAS-Bench-101 ([here](https://storage.googleapis.com/nasbench/nasbench_only108.tfrecord)), NAS-Bench-201 ([here](https://drive.google.com/open?id=16Y0UwGisiouVRxW-W5hEtbxmcHw_0hF_)) and NAS-Bench-301 ([here](https://figshare.com/articles/software/nasbench301_models_v0_9_zip/12962432)). We chose *nasbench_only108.tfrecord* for NAS-Bench-101, *NAS-Bench-201-v1_1-096897.pth* for NAS-Bench-201 and *nb_models_0.9.zip* for NAS-Bench-301. Save them under the [data](data) directory.

## Documentation
* The graph kernels and graph GP model introduced in our paper are implemented in [Graph_GP](Graph_GP). [graph_kernels.py](Graph_GP/graph_kernels.py) consists of the shortest-path based graph kernels (SP and ESP), [models.py](Graph_GP/models.py) is the graph GP and [graphGP_fitting.py](Graph_GP/graphGP_fitting.py) contains a fitting function.
* [nasbench](nasbench) is slightly modified code implementation of NAS-Bench-101 API. The other two benchmarks come with API after the corresponding packages are installed.
* [dataset](dataset.py) contains the three NAS benchmark datasets wrapped as classes.
* [graph.py](graph.py), [MIP.py](MIP.py) and [perf_metrics.py](perf_metrics.py) contains some utility functions for constructing graph, MIP and GP model performance metrics. In particular, [MIP.py](MIP.py) contains all the formulations mentioned in our paper.
* Run [GP_regression.py](GP_regression.py) will perform a GP regression on NAS-Bench-101 dataset, also include codes for plotting prediction performance.
* The final NAS-GOAT algorithm is implemented in [BO.py](BO.py).

## Example
Run [example.py](example.py) will replicate the graph BO NAS experiment in our paper on NAS-Bench-201 (cifar10-valid) with SP kernel.
