# A Closed-Form Solution for Fast and Reliable Adaptive Testing

This project focuses on the selection of optimal question subsets in adaptive testing and proposes a closed-form solution method (CFAT). This method can directly minimize the ability estimation error. By reducing the gradient bias and maintaining the stability of the Hessian matrix, it enables efficient question selection. Additionally, it can quantify the impact of human behavioral perturbations (guessing/slipping) on ability estimation. 

## What is Adaptive Testing About?


**Computerized Adaptive Testing** is a personalized and efficient assessment method that estimates an examinee's ability using the fewest possible questions. Originating from Item Response Theory (IRT) in the 1950s, CAT dynamically selects questions based on prior responses to maximize informativeness. Its core components include a psychometric model to estimate ability and a question selection algorithm. Widely used in many standardized tests like the GRE and GMAT, CAT offers higher accuracy and efficiency than traditional tests.

The CAT system alternates between estimating ability and selecting the next question. This loop continues until a stopping criterion is met, after which the final ability estimate is reported or used for further learning.




<!-- ![Figure 1](./figs/cat_image_1.png) -->
<!-- <div style="text-align:center;">
    <img src="./figs/cat_image_1.png" style="width:90%;">
</div> -->


<!-- The adaptive testing system consists of two key alternating components. At every test stage, the psychometric model (functioning as the user model) initially leverages the examinee's prior responses to gauge their current proficiency level. Subsequently, the selection algorithm selects the next item from the item pool based on specific criteria. This iterative two-step procedure continues until a pre-established stopping condition is satisfied. Finally, the individually estimated proficiency levels are provided as the assessment results or used to enhance future training processes.  -->

<!-- <div style="text-align:center;">
    <img src="./figs/cat_image_2.png" style="width:50%;">
</div> -->
<!-- ![Figure 2](./figs/cat_image_2.png) -->



## Installation

Git and install by `pip`

```
pip install -e .
```

## Data Preprocessing
To get the dataset used in experiments, you can use [Edudata](https://github.com/bigdata-ustc/EduData) package.
```
edudata download NIPS2020
edudata download ASSISTment2009-2010
```

Deconstruct the downloaded data as follows:
```
📂 data/
├── 📁 assistment/
│   └── assistment2009.csv 
├── 📁 nips/
|   ├── train_task_1_2.csv
|   ├── test_private_answers_task_1.csv
|   └── test_public_answers_task_1.csv
└── 📁 exam/
    └── triples.csv
```

Run the `assistment2009.ipynb` for data preprocessing to obtain the following structure (Take the assistment dataset as an example):
```
📂 scripts/
├── 📁 dataset/
│   ├──📄assistment2009.ipynb 
|   ├── concept_map.json
|   ├── metadata.json
|   ├── selected_data.csv
|   ├── test_triples.csv
|   ├── train_triples.csv
|   └── triples.csv
├── 📄test.py
└── 📄train.py
```
## Training
Run the following command to start training:
```
python train.py
```

## Testing
Run the following command to start testing:
```
python test.py
```

## Utils

### Visualization

By default, we use `tensorboard` to help visualize the reward of each iteration, see demos in `scripts` and use

```
tensorboard --logdir /path/to/logs
```

to see the visualization result.

