import sys
sys.path.append('..')

import CAT
import json
import torch
import logging
import datetime
import numpy as np
import pandas as pd
import random
import matplotlib.pyplot as plt
from tensorboardX import SummaryWriter


import os

def setuplogger(log_dir_):
    log_dir = log_dir_
    log_file_path = f"{log_dir}log.txt"

    # Check and create the directory
    if not os.path.exists(log_dir):
        os.makedirs(log_dir)
    root = logging.getLogger()
    root.setLevel(logging.INFO)
    if not any(isinstance(handler, logging.StreamHandler) for handler in root.handlers):
        handler = logging.StreamHandler(sys.stdout)
        handler.setLevel(logging.INFO)
        formatter = logging.Formatter("[%(levelname)s %(asctime)s] %(message)s")
        handler.setFormatter(formatter)
        root.addHandler(handler)
    file_handler = logging.FileHandler(log_file_path)
    file_handler.setLevel(logging.INFO)
    file_handler.setFormatter(formatter)
    root.addHandler(file_handler)

# tensorboard
log_dir = f"../logs/{datetime.datetime.now().strftime('%Y-%m-%d-%H-%M')}/"
setuplogger(log_dir)

seed = 0
np.random.seed(seed)
torch.manual_seed(seed)

print(log_dir)
writer = SummaryWriter(log_dir)

import CAT.strategy

# dataset
dataset = 'dataset'
# modify config here
config = {
    'learning_rate': 0.002,
    'batch_size': 128,
    'num_epochs': 20,
    'device': 'cpu',
    'pi_g':0.000,
    'pi_s':0.000
}

# Save the config parameters to a txt file
config_file_path = f"{log_dir}config.txt"
with open(config_file_path, 'w') as f:
    for key, value in config.items():
        f.write(f"{key}: {value}\n")


test_length = 10
# strategies
strategy = CAT.strategy.CFATStrategy()

# modify checkpoint path here
ckpt_path = '../ckpt/irt.pt'

# read datasets
test_triplets = pd.read_csv(f'./{dataset}/test_triples.csv', encoding='utf-8').to_records(index=False)
concept_map = json.load(open(f'./{dataset}/concept_map.json', 'r'))
concept_map = {int(k):v for k,v in concept_map.items()}
metadata = json.load(open(f'./{dataset}/metadata.json', 'r'))

# Initialize the adaptive test data set
test_data = CAT.dataset.AdapTestDataset(test_triplets, concept_map,
                                        metadata['num_test_students'], 
                                        metadata['num_questions'], 
                                        metadata['num_concepts'])

import itertools
import warnings
warnings.filterwarnings("ignore")



avg =[]
model = CAT.model.IRTModel(**config)
model.init_model(test_data)
model.adaptest_load(ckpt_path)
test_data.reset()
print(strategy.name)

logging.info(f'start adaptive testing with {strategy.name}')
logging.info(f'Iteration 0')

# evaluate models
results = model.evaluate(test_data)
for name, value in results.items():
    logging.info(f'{name}:{value}')

S_sel ={}
for sid in range(test_data.num_students):
    key = sid
    S_sel[key] = []
selected_questions={}
ranidx = {}

# Iterative selection of topics
for it in range(1, test_length + 1):
    # select question
    selected_questions= strategy.adaptest_select(model, test_data, S_sel)
    for sid in range(test_data.num_students):
        S_sel[sid].append(selected_questions[sid])

    # Application Topic selection
    for student, question in selected_questions.items():
        test_data.apply_selection(student, question)

    # update models
    model.adaptest_update(test_data)

    # Apply bias correction models for CFAT
    model.bias_adjust(test_data, S_sel)

    # evaluate models
    results = model.evaluate(test_data)
    # log results
    print("\n")
    logging.info(f'Iteration {it}')
    for name, value in results.items():
        logging.info(f'{name}:{value}')
        writer.add_scalars(name, {strategy.name: value}, it)






