import sys
sys.path.append('..')
import CAT
import json
import logging
import numpy as np
import pandas as pd

def setuplogger():
    root = logging.getLogger()
    root.setLevel(logging.INFO)
    handler = logging.StreamHandler(sys.stdout)
    handler.setLevel(logging.INFO)
    formatter = logging.Formatter("[%(levelname)s %(asctime)s] %(message)s")
    handler.setFormatter(formatter)
    root.addHandler(handler)

setuplogger()

# choose dataset here
dataset = 'dataset_assist'
# modify config here
config = {
    'learning_rate': 0.001,
    'batch_size': 128,
    'num_epochs': 100,
    'device': 'cpu',
}

# TensorBoard
log_dir = f"./{dataset}/log_training"

# read datasets
train_triplets = pd.read_csv(f'./{dataset}/train_triples.csv', encoding='utf-8').to_records(index=False)
concept_map = json.load(open(f'./{dataset}/concept_map.json', 'r'))
concept_map = {int(k):v for k,v in concept_map.items()}
metadata = json.load(open(f'./{dataset}/metadata.json', 'r'))

print(len(train_triplets))
print(len(concept_map))
print(len(metadata))

train_data = CAT.dataset.TrainDataset(train_triplets, concept_map,
                                      metadata['num_train_students'], 
                                      metadata['num_questions'], 
                                      metadata['num_concepts'])

# define model here
model = CAT.model.IRTModel(**config)
# train model
model.init_model(train_data)
model.train(train_data, log_step=10, tensorboard_dir=log_dir)

# save model
model.adaptest_save('../ckpt/irt.pt')




