import type { Metadata } from "next";
import { Merriweather } from "next/font/google"; // Changed import
import "./globals.css";

// Instantiate Merriweather font
const merriweather = Merriweather({
  subsets: ["latin"],
  weight: ["300", "400", "700", "900"], // Include desired weights
  variable: "--font-merriweather", // Optional: if you want to use it as a CSS variable
});

export const metadata: Metadata = {
  title: "FDA AI/ML Device Search", // Updated title
  description: "Generated by create next app",
  icons: {
    icon: '/favicon.svg',
  },
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en">
      <body className={`${merriweather.className} antialiased`}> {/* Apply Merriweather class */}
        {children}
      </body>
    </html>
  );
}
