# Doubly Robust P2P Learning Efficiency Benchmarks

### installation instructions:
```
wget https://raw.githubusercontent.com/emp-toolkit/emp-readme/master/scripts/install.py 
git clone https://github.com/emp-toolkit/emp-shmpc.git 
cd emp-shmpc && cmake . && make && sudo make install 
cd ml-shmpc/test
```
Then follow installation instructions for NTL: `https://libntl.org/`

Compile using `cmake . && make`

### instructions for replicating CPU time benchmarks:

For RSA, run the following command:

```
./bin/test_malicious_rsa_local_noprepro X Y
```

But replace X with the desired number of clients, and replace Y with the desired number of parameters in the model.

For CC, run the following command:
```
./bin/test_malicious_rsa_local_noprepro X (Y * THETA)
```

But replace X with the desired number of clients, and replace (Y * THETA) with the desired number of parameters in the model times the number of bits in the desired fixed point representation (in our study, we set THETA=32 for benchmarks with CC). We note that our CC protocol is essentially equivalent to the RSA protocol with a greater number of parameters, and thus we use the same code to benchmark both, but with different parameterizations.

For FLT, run the following command:

```
./bin/test_malicious_fltrust_local X Y THETA
```

But replace X with the desired number of clients, Y with the desired number of parameters in the model, and THETA with the number of bits in the fixed point representation (in our study, we set THETA=16 for benchmarks with FLT).