from statistics import NormalDist
from scipy.stats import binom

SECURITY_PARAM=2**(-40)

#n number of samples
#p proportion of malicious users
# compute the zscore of observing sample with dishonest majority
def size_isgood(n, p):
    mean = n * p
    var = n * p * (1-p)
    sd = var**(0.5)
    #print("mean:", mean, "var:", var, "sd:", sd)

    # number of sd away from mean to observe dishonest majority
    c = ((n/2.0) - mean) / sd

    #NormalDist.cdf(c) gives Pr[X <= c], i.e. Pr[honest majority]
    # so when this occurs with at least Pr 1 - security parameter,
    # then this is an acceptable sample size.
    goal = ((1-SECURITY_PARAM) < NormalDist().cdf(c)) #change to binomial
    return goal

#exhaustively search committee sizes to find the first good one
def find_good_committee_size(p=0.3333333, r=1000):
    for i in range(20, 1000):
        if size_isgood(i, p):
            return i
    return -1


def find_good_n_binom(p=0.3333333, r=1000):
    
    for i in range(20, 1000):
        is_good = ((1-SECURITY_PARAM) < binom.cdf(i/2, i, p))
        if is_good:
            return i
    return -1

def find_good_n_binom_third(p=.1, r=1000):
    for i in range(20, 10000):
        is_good = ((1-SECURITY_PARAM) < binom.cdf(i/3, i, p))
        if is_good:
            return i
    return -1

def find_good_n_binom_fourth(p=.1, r=1000):
    for i in range(20, 10000):
        is_good = ((1-SECURITY_PARAM) < binom.cdf(i/4, i, p))
        if is_good:
            return i
 
def find_good_n_binom_x(p=.1, r=1000):
    for i in range(20, 10000):
        is_good = ((1-SECURITY_PARAM) < binom.cdf(i/6, i, p))
        if is_good:
            return i
    return -1
