# StyleGuard Implementation

This project implements StyleGuard, a defense mechanism against style mimicry attacks in stable diffusion models, with a specific focus on Dreambooth training.

## Project Structure

```
.
├── attacks/               # Implementation of various attack methods
│   ├── aspl.py           # ASPL attack implementation
│   ├── styleguard.py     # StyleGuard defense implementation
│   ├── time_feature.py   # Time feature extraction
│   └── time_feature_style.py
├── scripts/              # Shell scripts for different operations
│   ├── attack_*.sh      # Various attack execution scripts
│   ├── styleguard.sh    # Main StyleGuard execution script
│   ├── evaluate.sh      # Evaluation scripts
│   └── train_*.sh       # Training scripts
└── requirements.txt      # Project dependencies
```

## Installation

To install the required dependencies, run the following command in your terminal:

```bash
pip install -r requirements.txt
```

This will install all necessary Python packages including PyTorch, TensorFlow, and other machine learning libraries.

## Usage

### Running StyleGuard

To generate perturbations using StyleGuard and train on Dreambooth, execute:

```bash
bash scripts/styleguard.sh
```

### Available Scripts

The project includes various scripts for different purposes:

- **Attack Scripts**:
  - `attack_aspl.sh`: Execute ASPL attacks
  - `attack_style.sh`: Style-based attacks
  - `attack_lora.sh`: LoRA-based attacks
  - And more in the `scripts` directory

- **Evaluation Scripts**:
  - `evaluate_styleguard.sh`: Evaluate StyleGuard performance

- **Training Scripts**:
  - `train_dreambooth_celeba.sh`: Train using CelebA dataset

## Main Features

1. **StyleGuard Defense**: Implementation of the StyleGuard defense mechanism against adversarial attacks
2. **Multiple Attack Methods**: Various attack implementations including ASPL, style-based, and LoRA-based attacks
3. **Evaluation Tools**: Scripts and tools for evaluating model performance and defense effectiveness
4. **Training Integration**: Integration with Dreambooth training pipeline

## Requirements

The project requires several Python packages listed in `requirements.txt`, including:
- PyTorch
- TensorFlow
- Transformers
- Other ML-related libraries

## Note

Make sure you have sufficient computational resources as the training and attack processes can be computationally intensive.