import torch
            
def test(model, testloader, m_eval=True):
    if m_eval:
        model.eval()
    with torch.no_grad():
        corrects = 0
        total = 0
        for x, y in testloader:
            x = x.cuda()
            y = y.cuda()
            y_hat = model(x)

            _, predicted = y_hat.max(1)
            corrects += predicted.eq(y).sum().item()
            total += y.size(0)
        print(f'test accuracy: {round(corrects / total * 100, 2)}%')
        model.train()
        return(corrects / total)
