import os
import pandas as pd
import logging
import random
import numpy as np
import torch

_log = logging.getLogger(__name__)


def set_global_seed(seed: int):
    random.seed(seed)
    np.random.seed(seed)
    torch.manual_seed(seed)
    if torch.cuda.is_available():
        torch.cuda.manual_seed_all(seed)
    torch.backends.cudnn.deterministic = True
    torch.backends.cudnn.benchmark = False

def save_synthetic_data(synthetic_data, output_dir, file_name):
    out_file = os.path.join(output_dir, file_name)
    synthetic_data.to_csv(out_file, index=False)
    _log.info(f"Synthetic data saved to {out_file}")