from abc import abstractmethod, ABC


class Config(ABC):
    def __init__(self):
        args = self.parse_args()
        
        self.dataset_name = args.dataset_name
        self.videos_dir = args.videos_dir
        self.msrvtt_train_file = args.msrvtt_train_file
        self.num_frames = args.num_frames
        self.video_sample_type = args.video_sample_type
        self.input_res = args.input_res

        self.exp_name = args.exp_name
        self.model_path = args.model_path 
        self.output_dir = args.output_dir
        self.save_every = args.save_every
        self.log_step = args.log_step
        self.evals_per_epoch = args.evals_per_epoch
        self.load_epoch = args.load_epoch
        self.eval_window_size = args.eval_window_size
        self.metric = args.metric

        self.huggingface = args.huggingface
        self.arch = args.arch
        self.clip_arch = args.clip_arch
        self.embed_dim = args.embed_dim

        self.loss = args.loss
        self.clip_lr = args.clip_lr
        self.noclip_lr = args.noclip_lr
        self.batch_size = args.batch_size
        self.num_epochs = args.num_epochs
        self.weight_decay = args.weight_decay
        self.warmup_proportion = args.warmup_proportion
    
        self.pooling_type = args.pooling_type
        self.k = args.k
        self.attention_temperature = args.attention_temperature
        self.num_mha_heads = args.num_mha_heads
        self.transformer_dropout = args.transformer_dropout

        self.num_workers = args.num_workers
        self.seed = args.seed
        self.no_tensorboard = args.no_tensorboard
        self.tb_log_dir = args.tb_log_dir

        self.datetime = args.datetime
        self.platform = args.platform
        self.diffusion_test_mode = args.diffusion_test_mode
        self.genframe_dir = args.genframe_dir
        self.gen_loss = args.gen_loss
        self.gen_loss_genvid2txt_weight = args.gen_loss_genvid2txt_weight
        self.gen_loss_genvid2vid_weight = args.gen_loss_genvid2vid_weight
        self.genframe_dir_tst = args.genframe_dir_tst
        self.align_txt = args.align_txt
        self.textgen_loss_weight = args.textgen_loss_weight
        self.genreal_loss_weight = args.genreal_loss_weight
        self.mean_branch_weight = args.mean_branch_weight
        self.std_weight = args.std_weight
        self.stochasic_trials = args.stochasic_trials
        self.kl_loss = args.kl_loss
        self.prior_mean = args.prior_mean
        self.prior_var = args.prior_var
        self.kl_loss_weight = args.kl_loss_weight
        self.gpu = args.gpu
        self.use_gen = args.use_gen
        self.var_net = args.var_net
        self.support_format = args.support_format
        self.support_loss_weight = args.support_loss_weight
        self.mean_net = args.mean_net
        self.batch_size_split = args.batch_size_split
        self.center_support_loss_weight = args.center_support_loss_weight
        self.train_mode = args.train_mode
        self.chunk_size = args.chunk_size
        self.noloss_record = args.noloss_record
        self.use_lightall_anyway = args.use_lightall_anyway
        self.duallinear_ac = args.duallinear_ac
        self.std = args.std
        self.stochastic_prior = args.stochastic_prior
        self.uniform_scale = args.uniform_scale
        self.raw_video = args.raw_video
        self.skip_eval = args.skip_eval
        self.sims_out_type = args.sims_out_type
        self.load_epoch_ls = args.load_epoch_ls
        self.DSL = args.DSL
        self.save_sims_for_plot = args.save_sims_for_plot

        self.apply_ldm = args.apply_ldm
        self.l1_loss = args.l1_loss
        self.l1_weight = args.l1_weight
        self.dpm_recon = args.dpm_recon
        self.layerscale_value = args.layerscale_value
        self.dpm_beta_schedule = args.dpm_beta_schedule
        self.n_timestep = args.n_timestep
        self.beta_linear_start = args.beta_linear_start
        self.beta_linear_end = args.beta_linear_end
        self.denoise_blks = args.denoise_blks
        # self.unet_in_channels = args.unet_in_channels
        # self.unet_out_channels = args.unet_out_channels
        self.vid_cond_dpm_arch = args.vid_cond_dpm_arch
        self.txt_cond_dpm_arch = args.txt_cond_dpm_arch
        self.sampling_type = args.sampling_type
        self.novidpool = args.novidpool
        self.DM_param_init = args.DM_param_init
        self.record_DM_param_stats = args.record_DM_param_stats
        self.training = args.training
        self.sce_weight = args.sce_weight
        self.output_dir_beforetrain = args.output_dir_beforetrain
        self.yml_pth = args.yml_pth

        self.DiT_blocks = args.DiT_blocks
        self.not_shared_feature_align = args.not_shared_feature_align
        self.feature_align_init = args.feature_align_init
        self.pretrained_DiT_pth = args.pretrained_DiT_pth
        self.blk_prefix = args.blk_prefix
        self.chunk_size_sampling = args.chunk_size_sampling
        self.eval_before_train = args.eval_before_train
        self.dm_loss_type = args.dm_loss_type
        self.trunc_timestep = args.trunc_timestep
        self.dm_lr = args.dm_lr
        self.dm_obj = args.dm_obj
        self.scheduler = args.scheduler
        self.DiT_vidpool_cond = args.DiT_vidpool_cond
        self.pretrain_num_epochs = args.pretrain_num_epochs
        self.training_recipe = args.training_recipe
        self.dm_loss_weight = args.dm_loss_weight
        self.test_log_custom = args.test_log_custom
        self.pretraining = args.pretraining
        self.v_posterior = args.v_posterior
        self.t_var = args.t_var
        self.wo_posterior_mean_coef1 = args.wo_posterior_mean_coef1
        self.wo_posterior_mean_coef2 = args.wo_posterior_mean_coef2
        self.logit_scale_dm_init = args.logit_scale_dm_init
        self.no_aligned_embed = args.no_aligned_embed
        self.diffusion_alignment_type = args.diffusion_alignment_type
        self.DiT_txt_contrastivediff_cond = args.DiT_txt_contrastivediff_cond
        self.alignment_var = args.alignment_var
        self.alignment_scaling = args.alignment_scaling
        self.alignment_target = args.alignment_target
        self.start_eval_epo = args.start_eval_epo
        self.no_cosine = args.no_cosine
        self.save_VT_embed_for_plot = args.save_VT_embed_for_plot

    @abstractmethod
    def parse_args(self):
        raise NotImplementedError

