#!/bin/bash

#please specify the save directory
Save_Dir='./'
# RuN HMC
python hmc.py -dataset sine -n_particles 50 -n_epoch 5000 -fix_variance 1. -dump_pred_dir  $Save_dir/hmc.bin -lr 1e-3
# Run SVGD
python linear_stein.py -psvi_method svgd -dataset sine -dump_pred_dir $Save_dir/svgd.bin -n_particles 10 -n_epoch 5000 -fix_variance 1. -lr 1e-3

# Run MAP estimate
python linear_stein.py -psvi_method map -dataset sine -dump_pred_dir $Save_dir/map.bin  -n_particles 10 -n_epoch 5000 -fix_variance 1. -lr 1e-3        

# Run Var(h)
python linear_VAR.py -psvi_method map -dataset sine -dump_pred_dir $Save_dir/cov_prop.bin  -n_particles 10 -n_epoch 5000 -fix_variance 1. -lr 1e-3

# Run Var-svgd(h)
python linear_VAR.py -psvi_method svgd -dataset sine -dump_pred_dir $Save_dir/cov_prop_sv.bin  -n_particles 10 -n_epoch 5000 -fix_variance 1. -lr 1e-3

# Run PAC2E
python linear_PAC2E.py -psvi_method map -dataset sine -dump_pred_dir $Save_dir/cov_pred.bin  -n_particles 10 -n_epoch 5000 -fix_variance 1. -lr 1e-3

#Plot the data please specify the save directory
python synthetic_vis.py