Code for *Loss function based second-order Jensen inequality and its application to particle variational inference*

This code is built on the code for *Function Space Particle Optimization for Bayesian Neural Networks*, ICLR 2019 (https://github.com/thu-ml/fpovi).
When you use our code, please cite the their paper too:
```
@inproceedings{
    wang2018function,
    title={Function Space Particle Optimization for {B}ayesian Neural Networks},
    author={Ziyu Wang and Tongzheng Ren and Jun Zhu and Bo Zhang},
    booktitle={International Conference on Learning Representations},
    year={2019},
    url={https://openreview.net/forum?id=BkgtDsCcKQ},
}
```


## Dependencies
- Python 3.7.6
- See `requirements.txt` for the comlete list
- Tensorflow-gpu 1.13.0
- zhusuan 0.4.0 (thu-ml/zhusuan (@`1011dd9`))
- tensorpack 0.8.6
- cleverhands 2.1.0
- meta-inf/experiments (@`60c0a77`)

## Usage
### Toydata experiments
- For toydata experiments using a neural network, please see `./ffn/run_toy.sh`
- For toydata experiments using a linear model, please see `./toy_linear/run.sh`

### Bayesian neural network regression
- Please see `./ffn/run_reg.sh`

### Bayesian neural network classification (MNIST)
- Please see `./ffn/run_class.sh`

### Bayesian neural network classification (Cifar10)
- Please see `./conv/convnet_run.sh`

### Contextual bandit
- Please see `./dcb/run.sh`
