#!/bin/bash

#please specify the save directory
Save_Dir='./'
# RuN HMC
%run -i hmc.py -dataset sine  -layers 50 50 -n_particles 50 -n_epoch 5000 -fix_variance 1. -dump_pred_dir  $Save_dir/hmc.bin -lr 1e-3

# Run SVGD
python %run -i bnn_stein.py -psvi_method svgd -dataset sine -dump_pred_dir $Save_dir/svgd.bin -layers 50 50 -n_particles 50 -n_epoch 5000 -fix_variance 0.2 -lr 1e-3

# Run GFSF
python %run -i bnn_stein.py -psvi_method gfsf -dataset sine -dump_pred_dir $Save_dir/gfsf.bin -layers 50 50 -n_particles 50 -n_epoch 5000 -fix_variance 0.2 -lr 1e-3

# Run MAP estimate
python %run -i bnn_stein.py -psvi_method map -dataset sine -dump_pred_dir $Save_dir/map.bin -layers 50 50 -n_particles 50 -n_epoch 5000 -fix_variance 0.2 -lr 1e-3 

# Run f-svgd
python %run -i bnn_stein_f.py -psvi_method svgd -dataset sine -dump_pred_dir $Save_dir/fsvgd.bin -layers 50 50 -n_particles 50 -n_epoch 5000 -fix_variance 0.2 -lr 1e-3  -mm_n_particles 400 

# Run Var(h)
python bnn_prop.py -psvi_method map -dataset sine -dump_pred_dir $Save_dir/var.bin -layers 50 50 -n_particles 50 -n_epoch 5000 -fix_variance 0.2 -lr 1e-3  -mm_n_particles 400 

# Run Var-svgd(h)
python bnn_prop_hm.py -psvi_method map -dataset sine -dump_pred_dir $Save_dir/var_hm.bin -layers 50 50 -n_particles 50 -n_epoch 5000 -fix_variance 0.2 -lr 1e-3  -mm_n_particles 400 

# Run PAC2E
python bnn_pac2e.py -psvi_method map psvi_method map -dataset sine -dump_pred_dir $Save_dir/pred.bin -layers 50 50 -n_particles 50 -n_epoch 5000 -fix_variance 0.2 -lr 1e-3  -mm_n_particles 400 

#Plot the data
python synthetic_vis.py