class GermanCredit(object):
    def __init__(self):
        self.name = 'GermanCredit'
        self.baseline = "/longterm/XXXX/repos/biased-adversary/eb_exp/resubmit_data/gc_baseline_model.h5"
        self.loo_list = [
            "/longterm/XXXX/repos/biased-adversary/eb_exp/resubmit_data/gc_loo_model_{}.h5"
            .format(i) for i in range(100)
        ] + [
            "/longterm/XXXX/repos/biased-adversary/eb_exp/resubmit_data/gc_loo_model_{}_ex.h5"
            .format(i) for i in range(400)
        ]
        self.rs_list = [
            "/longterm/XXXX/repos/biased-adversary/eb_exp/resubmit_data/models/gc_baseline_seed{}.h5"
            .format(i) for i in range(500)
        ]
        self.lip_baseline = "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-gc2.split-[Split.te-1.tr-4]/Model_64.16.8_100trials/models/loo_42.h5"
        self.lip_loo_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/luf_experiments/CustomData.name-gc2.split-[Split.te-1.tr-4]/Model_64.16.8_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]
        self.lip_rs_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-gc2.split-[Split.te-1.tr-4]/Model_64.16.8_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]
        self.num_classes = 2
        self.needs_layer = False


class Adult(object):
    def __init__(self):
        self.name = 'Adult'
        self.baseline = "/longterm/XXXX/repos/biased-adversary/eb_exp/resubmit_data/models/adult_baseline_model.h5"
        self.loo_list = [
            "/longterm/XXXX/repos/biased-adversary/eb_exp/resubmit_data/models/adult_loo_model_{}.h5"
            .format(i) for i in range(500)
        ]
        self.rs_list = [
            "/longterm/XXXX/repos/biased-adversary/eb_exp/resubmit_data/models/adult_baseline_model_seed{}.h5"
            .format(i) for i in range(500)
        ]
        self.lip_baseline = "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-ad2.split-[Split.te-15081.tr-15081]/Model_200_100trials/models/loo_42.h5"
        self.lip_loo_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/luf_experiments/CustomData.name-ad2.split-[Split.te-15081.tr-15081]/Model_200_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]
        self.lip_rs_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-ad2.split-[Split.te-15081.tr-15081]/Model_200_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]
        self.num_classes = 2
        self.needs_layer = False


class Seizure(object):
    def __init__(self):
        self.name = 'Seizure'
        self.baseline = "/longterm/XXXX/repos/biased-adversary/eb_exp/resubmit_data/seizure_baseline_model.h5"
        self.loo_list = [
            "/longterm/XXXX/repos/biased-adversary/eb_exp/resubmit_data/models/seizure_loo_model_{}.h5"
            .format(i) for i in range(500)
        ]
        self.rs_list = [
            "/longterm/XXXX/repos/biased-adversary/eb_exp/resubmit_data/seizure_baseline_model_seed{}.h5"
            .format(i) for i in range(500)
        ]
        self.lip_baseline = "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-sz2.split-[Split.te-3450.tr-8050]/Model_64.16.8_100trials/models/loo_42.h5"
        self.lip_loo_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/luf_experiments/CustomData.name-sz2.split-[Split.te-3450.tr-8050]/Model_64.16.8_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]
        self.lip_rs_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-sz2.split-[Split.te-3450.tr-8050]/Model_64.16.8_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]
        self.num_classes = 2
        self.needs_layer = False


class TaiwaneseCredit(object):
    def __init__(self):
        self.name = 'TaiwaneseCredit'
        self.baseline = "/longterm/XXXX/repos/ensemble_fairness/data/models/tai_baseline.h5"
        self.loo_list = [
            "/longterm/XXXX/repos/ensemble_fairness/data/tai_loo_model_{}.h5"
            .format(i) for i in range(500)
        ]
        self.rs_list = [
            '/longterm/XXXX/repos/ensemble_fairness/data/models/tai_baseline_seed{}.h5'
            .format(i) for i in range(500)
        ]

        self.lip_baseline = "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-tai2.split-[Split.te-7500.tr-22500]/Model_32.16_100trials/models/loo_42.h5"
        self.lip_loo_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/luf_experiments/CustomData.name-tai2.split-[Split.te-7500.tr-22500]/Model_32.16_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]
        self.lip_rs_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-tai2.split-[Split.te-7500.tr-22500]/Model_32.16_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]
        self.num_classes = 2
        self.needs_layer = False


class Warafin(object):
    def __init__(self):
        self.name = 'Warafin'
        self.baseline = "/longterm/XXXX/repos/ensemble_fairness/data/models/war_baseline.h5"
        self.loo_list = [
            "/longterm/XXXX/repos/ensemble_fairness/data/war_loo_model_{}.h5"
            .format(i) for i in range(500)
        ]
        self.rs_list = [
            '/longterm/XXXX/repos/ensemble_fairness/data/models/war_baseline_seed{}.h5'
            .format(i) for i in range(500)
        ]

        self.lip_baseline = "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-war2.split-[Split.te-1205.tr-3614]/Model_100_100trials/models/loo_42.h5"
        self.lip_loo_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/luf_experiments/CustomData.name-war2.split-[Split.te-1205.tr-3614]/Model_100_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]
        self.lip_rs_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-war2.split-[Split.te-1205.tr-3614]/Model_100_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]
        self.num_classes = 3
        self.needs_layer = False


class HELOC(object):
    def __init__(self):
        self.name = 'HELOC'
        self.baseline = "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-hel.split-[Split.te-2615.tr-7844]/Model_100.32_100trials/models/loo_42.h5"
         self.baseline_weights= "/longterm/XXXX/repos/ensemble_fairness/data/HELOC_baseline_weights.h5"

        self.loo_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/luf_experiments/CustomData.name-hel.split-[Split.te-2615.tr-7844]/Model_100.32_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]
        self.loo_weights=["/longterm/XXXX/repos/ensemble_fairness/data/HELOC_loo_{}_weights.h5".format(i) for i in range(100)]
        
        self.rs_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-hel.split-[Split.te-2615.tr-7844]/Model_100.32_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]
        self.rs_weights = ["/longterm/XXXX/repos/ensemble_fairness/data/HELOC_rs_{}_weights.h5".format(i) for i in range(100)]
        

        self.lip_baseline = "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-hel_lip.split-[Split.te-2615.tr-7844]/Model_100.32_100trials/models/loo_42.h5"
        self.lip_loo_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/luf_experiments/CustomData.name-hel_lip.split-[Split.te-2615.tr-7844]/Model_100.32_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]
        self.lip_rs_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-hel_lip.split-[Split.te-2615.tr-7844]/Model_100.32_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]
        self.num_classes = 2
        self.needs_layer = True


class Breast(object):
    def __init__(self):
        self.name = 'Breast'
        self.baseline = "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/BreastCancer.split-[Split.seed-0.te-1.tr-3]/Model_100.32.16_100trials/models/loo_42.h5"
        self.loo_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/luf_experiments/BreastCancer.split-[Split.seed-0.te-1.tr-3]/Model_100.32.16_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]

        self.rs_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/BreastCancer.split-[Split.seed-0.te-1.tr-3]/Model_100.32.16_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]

        self.lip_baseline = "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/BreastCancer.split-[Split.seed-0.te-2.tr-6]/Model_100.32.16_100trials/models/loo_42.h5"

        self.lip_loo_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/luf_experiments/BreastCancer.split-[Split.seed-0.te-2.tr-6]/Model_100.32.16_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]

        self.lip_rs_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/BreastCancer.split-[Split.seed-0.te-2.tr-6]/Model_100.32.16_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]

        self.num_classes = 2
        self.needs_layer = True


class Pima(object):
    def __init__(self):
        self.name = 'Pima'
        self.baseline = "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-pima.processors-normalize.split-[Split.seed-0.te-1.tr-4]/Model_100_100trials/models/loo_42.h5"
        self.loo_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/luf_experiments/CustomData.name-pima.processors-normalize.split-[Split.seed-0.te-1.tr-4]/Model_100_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]

        self.rs_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-pima.processors-normalize.split-[Split.seed-0.te-1.tr-4]/Model_100_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]

        self.lip_baseline = "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-pima_lip.processors-normalize.split-[Split.seed-0.te-1.tr-4]/Model_100_100trials/models/loo_42.h5"
        self.lip_loo_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/luf_experiments/CustomData.name-pima_lip.processors-normalize.split-[Split.seed-0.te-1.tr-4]/Model_100_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]

        self.lip_rs_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-pima_lip.processors-normalize.split-[Split.seed-0.te-1.tr-4]/Model_100_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]

        self.num_classes = 2
        self.needs_layer = True


class CTG(object):
    def __init__(self):
        self.name = 'CTG'
        self.baseline = "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-ctg.processors-normalize.split-[Split.seed-0.te-1.tr-4]/Model_100_100trials/models/loo_42.h5"
        self.loo_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/luf_experiments/CustomData.name-ctg.processors-normalize.split-[Split.seed-0.te-1.tr-4]/Model_100_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]

        self.rs_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-ctg.processors-normalize.split-[Split.seed-0.te-1.tr-4]/Model_100_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]

        self.lip_baseline = "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-ctg_lip.processors-normalize.split-[Split.seed-0.te-1.tr-4]/Model_100_100trials/models/loo_42.h5"
        self.lip_loo_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/luf_experiments/CustomData.name-ctg_lip.processors-normalize.split-[Split.seed-0.te-1.tr-4]/Model_100_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]

        self.lip_rs_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-ctg_lip.processors-normalize.split-[Split.seed-0.te-1.tr-4]/Model_100_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]

        self.num_classes = 2
        self.needs_layer = True


class Thyroid(object):
    def __init__(self):
        self.name = 'Thyroid'
        self.baseline = "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-thy.processors-normalize.split-[Split.seed-0.te-1.tr-4]/Model_100_100trials/models/loo_42.h5"
        self.loo_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/luf_experiments/CustomData.name-thy.processors-normalize.split-[Split.seed-0.te-1.tr-4]/Model_100_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]

        self.rs_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-thy.processors-normalize.split-[Split.seed-0.te-1.tr-4]/Model_100_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]

        self.lip_baseline = [
            "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-thy_lip.processors-normalize.split-[Split.seed-0.te-1.tr-4]/Model_100_100trials/models/loo_42.h5"
            .format(i) for i in range(100)
        ]
        self.lip_loo_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/luf_experiments/CustomData.name-thy_lip.processors-normalize.split-[Split.seed-0.te-1.tr-4]/Model_100_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]

        self.lip_rs_list = [
            "/longterm/XXXX/repos/ensemble_fairness/code/rs_experiments/CustomData.name-thy_lip.processors-normalize.split-[Split.seed-0.te-1.tr-4]/Model_100_100trials/models/loo_{}.h5"
            .format(i) for i in range(100)
        ]

        self.num_classes = 2
        self.needs_layer = True


def getPretrainedNetworks(data):
    for path_2_model in [
            GermanCredit(),
            Adult(),
            Seizure(),
            Warafin(),
            TaiwaneseCredit(),
            HELOC(),
            Breast(),
            Pima(),
            CTG(),
            Thyroid()
    ]:
        if data.lower() == path_2_model.name.lower():
            return path_2_model