# Implementation of Consistent Counterfactuals for Deep Models

## Dependencies
- Python = 3.8.1
- Tensorflow = 2.3.0
- datalib-dev
- pandas=1.1.1

To create a conda environment for Linux that runs the training code in the paper, do 

```shell
conda env create -f training_env.yml
```

To create a conda environment for Linux that runs the evaluations in the paper, do 

```shell
conda env create -f eval.yml
```

and install `scriptify`

```shell
cd scritify
pip install -e .
```

## Training

### Prepare data

1. Download datasets
2. Preprocess and split into train and test
3. Store into files outlined in `model_training.py`

### Train models

1. In an environment with all dependencies installed, run `model_training.py`

## Evaluations

### Change the directory
```shell
cd evaluations
```
### Modify the models and data path

1. Update `model_configs.py` and `model_strings.py` to point to the pretrained models.

2. Update `latent_space/utils.py` to point to the directories of data.

### Trainng Auto-Encoders:
```shell
cd latent_space

python train_vae.sh --model_type ae --epochs 500 --data GermanCredit
python train_vae.sh --model_type ae --epochs 500 --data Seizure
python train_vae.sh --model_type ae --epochs 500 --data CTG
python train_vae.sh --model_type ae --epochs 500 --data Warafin
python train_vae.sh --model_type ae --epochs 500 --data HELOC
python train_vae.sh --model_type ae --epochs 500 --data TaiwaneseCredit
```

### Reproduce the paper's evaluations

```shell
sh run_all.sh
sh run_rns_stab.sh
```



