import inspect
import numpy as np
import os
import subprocess

from decorator import decorator

from scriptify.scriptify import _parse_arg_from_string


def _dump_code(f, code_file_name, res_file_name):
    with open(code_file_name, 'w') as f2:
        f2.write('from scriptify import scriptify\n')
        f2.write('from scriptify.subprocessify import save_result\n')
        for line in inspect.getsourcelines(inspect.getmodule(f))[0]:
            if not '@subprocessify' in line:
                f2.write(line
                    .replace('@scriptify', '')
                    .replace('__main__', 'NOT_MAIN'))

        f2.write(f'\n@scriptify\n')
        f2.write(f'@save_result(file_name="{res_file_name}")\n')
        for line in inspect.getsourcelines(f)[0]:
            if not '@subprocessify' in line:
                f2.write(line)


def save_result(file_name, save_format='np'):

    @decorator
    def _fn_with_saving(fn, *args, **kwargs):
        print('>>>>>>>>> converting array files to arrays')
        new_args = []
        for i, arg in enumerate(args):
            if (isinstance(arg, str) and 
                    arg.startswith('/tmp/subprocessify_np_arg')):
                new_args.append(np.load(arg))
                os.remove(arg)
            else:
                new_args.append(arg)

        args = new_args

        for i in kwargs:
            if (isinstance(kwargs[i], str) and 
                    arg.startswith('/tmp/subprocessify_np_arg')):
                kwargs[i] = np.load(arg)

        print('\n>>>>>>>>>> about to run function\n')
        res = fn(*args, **kwargs)
        print('\n>>>>>>>>>> ran function, going to save result\n')

        if save_format == 'np':
            np.save(f'{file_name}.npy', res)
            print(f'\nSAVED AS {file_name}.npy\n')

    return _fn_with_saving


def subprocessify(save_format='np'):

    if save_format == 'np':
        pass
    else:
        raise ValueError(f'unrecognized save format: {save_format}')

    @decorator
    def _subprocessify(fn, *args, **kwargs):

        fn_tmp_file = f'/tmp/subprocessify_code_{np.abs(np.random.rand())}.py'
        tmp_file = f'/tmp/subprocessify_res_{np.abs(np.random.rand())}'

        _dump_code(fn, fn_tmp_file, tmp_file)

        ps = ['python', fn_tmp_file]

        for n, v in zip(inspect.signature(fn).parameters, args):
            if isinstance(v, bool):
                if v:
                    ps.append(f'--{n}')

            elif isinstance(v, np.ndarray):
                array_name = (
                    f'/tmp/subprocessify_np_arg_{np.abs(np.random.rand())}.npy')
                print(array_name)
                print(array_name)
                np.save(array_name, v)
                ps.append(f'--{n}')
                ps.append(f'{array_name}')

            else:
                ps.append(f'--{n}')
                ps.append(f'{v}')

        print(ps)

        subprocess.run(ps)

        if save_format == 'np':
            res = np.load(f'{tmp_file}.npy')

            os.remove(f'{tmp_file}.npy')

        os.remove(fn_tmp_file)

        return res

    return _subprocessify
