set -x

# grpo
export PYTORCH_CUDA_ALLOC_CONF=expandable_segments:True
export MASTER_PORT=22345                                        

ray job submit --address="http://127.0.0.1:8265" \
   -- python3 -m openrlhf.cli.appworld_rl \
   --ref_num_nodes 1 \
   --ref_num_gpus_per_node 8 \
   --reward_num_nodes 1 \
   --reward_num_gpus_per_node 8 \
   --actor_num_nodes 1 \
   --actor_num_gpus_per_node 8 \
   --vllm_num_engines 8 \
   --vllm_tensor_parallel_size 1 \
   --colocate_all_models \
   --vllm_gpu_memory_utilization 0.5 \
   --pretrain /models/qwen3_8b\
   --remote_rm_url /home/OpenRLHF_2/OpenRLHF/examples/scripts/reward_func_split.py  \
   --save_path /models/appworld_8b_without_kl_ppo_rollout_batch40 \
   --ckpt_path /models/appworld_8b_without_kl_ppo_rollout_batch40/ckpt \
   --save_hf_ckpt \
   --micro_train_batch_size 1 \
   --train_batch_size 8 \
   --micro_rollout_batch_size 1 \
   --rollout_batch_size 10 \
   --n_samples_per_prompt 6 \
   --max_epochs 1 \
   --max_len 26000 \
   --prompt_max_len 25000 \
   --zero_stage 3 \
   --num_episodes 100 \
   --bf16 \
   --actor_learning_rate 5e-7 \
   --normalize_reward \
   --adam_offload \
   --packing_samples \
   --gradient_checkpointing \
   --save_steps 20 \
   --vllm_sync_backend nccl \
   --enforce_eager \
   --vllm_enable_sleep \
   --deepspeed_enable_sleep \
   --init_kl_coef 0 \
   # --use_kl_loss \
   # --kl_estimator k3 \
   # --gamma 1.0 \
   # --advantage_estimator group_norm \

#   --use_wandb 8c443361ad07581db062c94b2ac26436023d41df




# You could also try
#   --kl_estimator k2 \
#   --gradient_checkpointing \

# also supports --advantage_estimator rloo | reinforce_baseline
