set -x

# grpo
export PYTORCH_CUDA_ALLOC_CONF=expandable_segments:True
export MASTER_PORT=12345

ray job submit --address="http://127.0.0.1:8265" \
   -- python3 -m openrlhf.cli.appworld_rl \
   --ref_num_nodes 1 \
   --ref_num_gpus_per_node 8 \
   --reward_num_nodes 1 \
   --reward_num_gpus_per_node 8 \
   --actor_num_nodes 1 \
   --actor_num_gpus_per_node 8 \
   --vllm_num_engines 2 \
   --vllm_tensor_parallel_size 4 \
   --colocate_all_models \
   --vllm_gpu_memory_utilization 0.5 \
   --pretrain /models/qwen2.5_32b\
   --remote_rm_url /home/OpenRLHF_2/OpenRLHF/examples/scripts/reward_func_split.py  \
   --save_path /models/appworld_32b_lora_without_kl_ppo_rollout_batch10 \
   --ckpt_path /models/appworld_32b_lora_without_kl_ppo_rollout_batch10 \
   --save_hf_ckpt \
   --micro_train_batch_size 1 \
   --train_batch_size 8 \
   --micro_rollout_batch_size 1 \
   --rollout_batch_size 40 \
   --n_samples_per_prompt 6 \
   --lora_rank 16 \
   --lora_alpha 32 \
   --max_epochs 1 \
   --max_len 25000 \
   --prompt_max_len 24000 \
   --zero_stage 3 \
   --num_episodes 100 \
   --bf16 \
   --actor_learning_rate 5e-5 \
   --normalize_reward \
   --adam_offload \
   --packing_samples \
   --gradient_checkpointing \
   --gradient_checkpointing_use_reentrant \
   --save_steps 4 \
   --vllm_sync_backend nccl \
   --enforce_eager \
   --vllm_enable_sleep \
   --deepspeed_enable_sleep \
   --init_kl_coef 0 \
   # --use_kl_loss \
   # --kl_estimator k3 \
   # --gamma 1.0 \
   # --advantage_estimator group_norm \

#   --use_wandb 8c443361ad07581db062c94b2ac26436023d41df




# You could also try
#   --kl_estimator k2 \
#   --gradient_checkpointing \

# also supports --advantage_estimator rloo | reinforce_baseline
#如果您使用了 LoRA (Low-Rank Adaptation)，默认保存下来的文件并非完整模型权重，而是 LoRA Adapter，若想按完整权重的方式进行后续任务，您需要将 Adapter 与训练前的模型权重进行合并
# python -m openrlhf.cli.lora_combiner \
#     --model_path meta-llama/Meta-Llama-3-8B \
#     --lora_path ./checkpoint/llama3-8b-rm \
#     --output_path ./checkpoint/llama-3-8b-rm-combined \
#     --is_rm \
#     --bf16