set -x

# grpo

ray job submit --address="http://127.0.0.1:8265" \
   -- python3 -m openrlhf.cli.appworld_rl \
   --ref_num_nodes 1 \
   --ref_num_gpus_per_node 8 \
   --reward_num_nodes 1 \
   --reward_num_gpus_per_node 8 \
   --actor_num_nodes 1 \
   --actor_num_gpus_per_node 8 \
   --vllm_num_engines 8 \
   --vllm_tensor_parallel_size 1 \
   --vllm_gpu_memory_utilization 0.6 \
   --pretrain /models/qwen3_8b \
   --remote_rm_url /home/OpenRLHF_2/OpenRLHF/examples/scripts/reward_func_split.py \
   --save_path /models/model_save \
   --ckpt_path /models/model_ckpt_save \
   --micro_train_batch_size 2 \
   --train_batch_size 16 \
   --micro_rollout_batch_size 1 \
   --rollout_batch_size 16 \
   --n_samples_per_prompt 8 \
   --max_epochs 1 \
   --max_len 32500 \
   --prompt_max_len 30720 \
   --gamma 1.0 \
   --advantage_estimator rloo \
   --zero_stage 2 \
   --num_episodes 100 \
   --bf16 \
   --actor_learning_rate 5e-5 \
   --temperature 0.7 \
   --top_p 0.9 \
   --normalize_reward \
   --adam_offload \
   --packing_samples \
   --save_steps 5000 \
   --vllm_sync_backend nccl \
   --enforce_eager \
   --vllm_enable_sleep \
   --init_kl_coef 0.0 \
   --deepspeed_enable_sleep



# You could also try
#   --kl_estimator k2 \
#   --gradient_checkpointing \
   # --lora_rank 16 \
   # --lora_alpha 32 \
 #  --gradient_checkpointing \
# also supports --advantage_estimator rloo | reinforce_baseline
