import os
import datetime
from parser import Parser
from modules.launcher import Launcher

def main(opt):

	opt = get_settings(opt)
	os.environ['CUDA_VISIBLE_DEVICES']=opt.gpu

	l = Launcher(opt)
	if opt.worker_type == 'server':
		l.run_server()
	elif opt.worker_type == 'client':
		l.run_clients()
	elif opt.worker_type == 'data':
		l.generate_data()
	else:
		SystemExit('SystemExit: no proper worker type was given.')

def get_settings(opt):

	now = datetime.datetime.now().strftime("%Y%m%d-%H%M")

	opt.socket_test        = False
	opt.disable_adaptive   = False # deprecated
	opt.disable_sparsity   = False # deprecated
	opt.global_random_seed = 1

	opt.host_ip            = '0.0.0.0'
	opt.log_dir            = 'outputs/logs/{}/'.format(now)
	opt.weights_dir        = 'outputs/weights/{}/'.format(now)
	opt.mixture_filename   = 'saved_mixture.npy'

	# CIFAR10: 0, CIFAR100: 1, MNIST(10): 2, SVHN(10): 3,
	# FMNIST(10): 4, TrafficSign(43): 5, FaceScrub(100): 6, NMNIST(10): 7
	# if opt.task_pool == 0: # NonIID-50
	# 	opt.dataset        = [0, 1, 2, 3, 4, 5, 6, 7]
	# 	opt.split_option   = 'non_iid'
	# 	opt.num_classes    = 5
	# 	opt.num_examples   = -1 # -1 if full examples
	# 	opt.num_pick_tasks = 10 # -1 if use all tasks
	# elif opt.task_pool == 1: # NonIID-CIFAR100
	# 	opt.dataset        = [1]
	# 	opt.split_option   = 'non_iid'
	# 	opt.num_classes    = 2
	# 	opt.num_examples   = -1 # -1 if full examples
	# 	opt.num_pick_tasks = 10 # -1 if use all tasks
	# elif opt.task_pool == 2: # Hetero-8
	# 	opt.dataset        = [0, 2, 3, 4, 7]
	# 	opt.split_option   = 'iid'
	# 	opt.num_classes    = -1 # -1 if full classes
	# 	opt.num_examples   = -1 # -1 if full examples
	# 	opt.num_pick_tasks = -1 # -1 if use all tasks
	# elif opt.task_pool == 3: # Full-MNIST
	# 	opt.dataset        = [2]
	# 	opt.split_option   = 'iid'
	# 	opt.num_classes    = -1
	# 	opt.num_examples   = -1 # -1 if full examples
	# 	opt.num_pick_tasks = -1 # -1 if use all tasks
	# elif opt.task_pool == 4: # Full-SVHN
	# 	opt.dataset        = [3]
	# 	opt.split_option   = 'iid'
	# 	opt.num_classes    = -1
	# 	opt.num_examples   = -1 # -1 if full examples
	# 	opt.num_pick_tasks = -1 # -1 if use all tasks
	# elif opt.task_pool == 5: # Full-CIFAR10
	# 	opt.dataset        = [0]
	# 	opt.split_option   = 'iid'
	# 	opt.num_classes    = -1
	# 	opt.num_examples   = -1 # -1 if full examples
	# 	opt.num_pick_tasks = -1 # -1 if use all tasks
	# elif opt.task_pool == 6: # Full-CIFAR10
	# 	opt.dataset        = [1]
	# 	opt.split_option   = 'iid'
	# 	opt.num_classes    = -1
	# 	opt.num_examples   = -1 # -1 if full examples
	# 	opt.num_pick_tasks = -1 # -1 if use all tasks
	if opt.task_pool == 7: # CIFAR100-superclass-overlapped
		opt.dataset        = [1]
		opt.c100_superclass = True
		opt.split_option   = 'overlapped'
		opt.num_classes    = 5
		opt.num_examples   = -1 # -1 if full examples
		opt.num_pick_tasks = 10 # -1 if use all tasks
	# elif opt.task_pool == 2: # Overlapped-50
	# 	opt.dataset        = [0, 2, 3, 4, 7]
	# 	opt.split_option   = 'overlapped'
	# 	opt.num_classes    = 5
	# 	opt.num_examples   = -1 # -1 if full examples
	# 	opt.gen_num_tasks  = 10 # when generating tasks if overlapped
	# 	opt.from_task_pool = True
	# 	opt.pool_size      = 50

	return opt

if __name__ == '__main__':
	main(Parser().parse())
