import os
import json
import time
import atexit
import multiprocessing

from common.utils import *
from modules.server import Server
from modules.client import Client
from modules.config import Config
from data.generator import DataGenerator

SLEEP_INTERVAL = 60 # seconds

class Launcher:

        def __init__(self, args):
                self.opt = args
                self.processes = []

        def run_server(self):
                self.server = Server(self.opt)
                self.server.run()

        def run_clients(self):
                if self.opt.gpu == '-1':
                        for cid in range(self.opt.num_clients):
                                config = Config(self.opt)
                                self.opt = config.get_options()
                                self.spawn_client_process()
                else:
                        config = Config(self.opt)
                        self.opt = config.get_options()
                        Client(self.opt)
                        #self.spawn_client_process()
                #atexit.register(self.kill_processes)
                #print('[notice] all client processes will be terminated if you kill this main process.')
                #while True:
                #       time.sleep(SLEEP_INTERVAL)

        def spawn_client_process(self):
                p = multiprocessing.Process(target=self.init_client, args=())
                p.start()
                self.processes.append(p)
                print('client started with pid %d' %(p.pid))

        def init_client(self):
                Client(self.opt)

        def kill_processes(self):
                for p in self.processes:
                        pid = p.pid
                        p.terminate()
                        print('[notice] pid: %d has been terminated' %(pid))

        def generate_data(self):
                start_time = time.time()
                data_generator = DataGenerator(-1, self.opt)
                data_generator.generate_data()
                data_info = data_generator.get_info()
                syslog(-1, 'done (%d sec)' %(time.time()-start_time))
