export num_gpus=1
export CUBLAS_WORKSPACE_CONFIG=":16:8" # https://docs.nvidia.com/cuda/cublas/index.html#cublasApi_reproducibility
export CUDA_VISIBLE_DEVICES=2
python examples/text-classification/run_glue_bilevel.py \
--model_name_or_path microsoft/deberta-v3-base \
--arch_init_checkpoint checkpoint/debertav3/mnli/arch.13800.pt \
--model_init_checkpoint checkpoint/debertav3/mnli/model.13800.pt \
--task_name rte \
--max_seq_length 320 \
--train_batch_size 32 \
--eval_batch_size 64 \
--weight_decay 0.12 \
--arch_weight_decay 0.1 \
--apply_lora \
--lora_r 8 \
--lora_alpha 16 \
--lr 4e-6 \
--arch_lr 4e-6 \
--seed 0 \
--valid_step 10 \
--unroll_step 1 \
--max_step 500 \
--train_iters 500 \
--warmup_step 30 \