# Neural Signal Codec (NSC) — Code Release

This repository provides the implementation of the proposed Neural Signal Codec (NSC) and all supporting experiments reported in the paper.  
The code is organized into the following modules:

## Repository Structure

- **NSC_module/**  
  Core implementation of the proposed NSC encoder, decoder and loss design.

- **Ablation_Codes/**  
  Three Jupyter notebooks for ablation studies:  
  - Variants of the NSC encoder design.  
  - Different loss function settings.
  - wlr + EAL-G test.

- **Compare_Codes/**  
  Implementations of all baseline models used for comparison in the paper.

- **Analyze/**  
  - Script for constructing comparison tables in the paper.  
  - Script for clustering analysis of latent representations.

- **MITBIH_Codes/**  
  Codes used for generalization experiments on the MIT-BIH Arrhythmia dataset.

- **dataset/**  
  - Preprocessed dataset files used in the experiments.  
  - Metric functions (e.g., PSNR, NMI, ARI) implemented in Python.

## Usage

Each subfolder contains self-contained scripts or notebooks with detailed comments.  
To reproduce the main results:  
1. Move the file you want to use into the main folder.
2. Click the running button.
3. All the results file and models will saved.
4. Use the code in **Analyze/** for further study.

## Requirements

Python >= 3.12.3
Others can be found in requirements.txt
