import numpy as np

# Augmentation
# not used

# INDEX --- PSNR R2 MSE SNDR
def psnr(reconstructed, target, eps = 1e-10):
    data_range = np.max(target) - np.min(target)
    mse = np.mean((reconstructed - target) ** 2)
    return 20 * np.log10(data_range / np.sqrt(mse + eps))

def r2_score(reconstructed, target, eps=1e-10):
    ss_res = np.sum((target - reconstructed) ** 2)
    ss_tot = np.sum((target - np.mean(target)) ** 2)
    return 1 - ss_res / (ss_tot + eps)

def sndr(reconstructed, target, eps=1e-10):
    sig_part = np.linalg.norm(target, ord=2)
    loss_part = np.linalg.norm(target-reconstructed, ord=2)
    return 20 * np.log10((sig_part + eps) / (loss_part + eps))

def nrmse(reconstructed, target, eps=1e-10):
    mse = np.mean((reconstructed - target) ** 2)
    rmse = np.sqrt(mse + eps)
    data_range = np.max(target) - np.min(target)
    return rmse / (data_range + eps)
