# ActNet
Repository for ActNet code and ablation experiments. This code requires common libraries of the JAX environment, such as Flax (for neural network design) and Optax (for training and optimization). Plotting is done using Matplotlb.

Experiments comparing against the state-of-the-art require integration with JaxPi, which is an open-source library. We will work to integrate ActNet with this library in the future and are happy to provide more details if requested by reviewers.

* archs.py : includes the architectures used in the paper, including JAX implementations of ActNet, KAN and Siren.
* models.py : includes a training model that can be used with any of the architectures.
* utils.py : includes useful code for sampling batches.
* poisson_2d/ : directory containing minimal code to run the Poisson 2D problem with any desired architecture.
* helmholtz_2d/ : directory containing minimal code to run the Helmholtz 2D problem with any desired architecture.
* allen_cahn/ : directory containing minimal code to run the Allen-Cahn problem with any desired architecture.