set -x
# export CUDA_VISIBLE_DEVICES=0

DATASET_NAME=$1
DATE=$2
STRATEGY=$3
if [ -n "$4" ]; then
    SAVE_NAME=$4
else
    SAVE_NAME=${STRATEGY}
fi

read -r -d '' training_commands <<EOF
openrlhf.cli.train_dpo \
   --save_path ./save/${DATASET_NAME}/${DATE}/${SAVE_NAME} \
   --logging_steps 1 \
   --eval_steps -1 \
   --train_batch_size 16 \
   --micro_train_batch_size 2 \
   --pretrain ./models/Llama-3.1-Tulu-3-8B-SFT \
   --bf16 \
   --max_epochs 1 \
   --max_len 4096 \
   --zero_stage 3 \
   --learning_rate 5e-7 \
   --beta 0.1 \
   --dataset ./dpo_datasets/${DATASET_NAME}/${DATE}/${STRATEGY} \
   --apply_chat_template \
   --chosen_key chosen \
   --rejected_key rejected \
   --flash_attn \
   --load_checkpoint \
   --use_tensorboard ./tensorboard/${DATASET_NAME}/${DATE}/${SAVE_NAME} \
   --gradient_checkpointing
EOF
    # --use_wandb [WANDB_TOKENS] or True (use wandb login command)
    # --ipo [for IPO]
    # --label_smoothing 0.1 [for cDPO]
    # --ref_offload
    # --packing_samples
    # --nll_loss_coef (Regularization with NLL loss)
    # --ckpt_path
    # --save_steps
    # --nll_loss_coef 0.05


# if [[ ${1} != "slurm" ]]; then
#     deepspeed --module $training_commands
# fi
deepspeed --module $training_commands