""" Generate commands for meta-train phase. """
import os

def run_exp(num_batch=1000, shot=1, query=15, lr1=0.0001, lr2=0.001, base_lr=0.01, update_step=10, gamma=0.5):
    max_epoch = 100
    way = 5
    step_size = 10
    gpu = 0 # '0,1'#1#0

    the_command = 'python3.6 main.py' \
                  + ' --max_epoch=' + str(max_epoch) \
                  + ' --num_batch=' + str(num_batch) \
                  + ' --shot=' + str(shot) \
                  + ' --train_query=' + str(query) \
                  + ' --way=' + str(way) \
                  + ' --meta_lr1=' + str(lr1) \
                  + ' --meta_lr2=' + str(lr2) \
                  + ' --step_size=' + str(step_size) \
                  + ' --gamma=' + str(gamma) \
                  + ' --gpu=' + str(gpu) \
                  + ' --base_lr=' + str(base_lr) \
                  + ' --dataset=' + 'mini' \
                  + ' --dataset_dir=' + './data/mini' \
                  + ' --init_weights=' + './checkpoints/mini/res12.pth' \
                  + ' --model_type=' + 'res12' \
                  + ' --meta_label=' + 'ED' \
                  + ' --datatuple=' + str(3) \
                  + ' --update_step=' + str(update_step)

    os.system(the_command + ' --phase=proto_train')
    os.system(the_command + ' --phase=proto_eval')

# model_type: res12
# dataset: mini cifar_fs fc100 cub
run_exp(num_batch=100, shot=1, query=15, lr1=0.0001, lr2=0.001, base_lr=0.01, update_step=100, gamma=0.5)
run_exp(num_batch=100, shot=5, query=15, lr1=0.0001, lr2=0.001, base_lr=0.01, update_step=100, gamma=0.5)
