_base_ = [
    '../_base_/models/segformer_sensor-b0.py',
    '../_base_/datasets/cityscapes_full.py',
    '../_base_/default_runtime.py', '../_base_/schedules/schedule_160k.py'
]
data_preprocessor = dict()
checkpoint = 'https://download.openmmlab.com/mmsegmentation/v0.5/pretrain/segformer/mit_b0_20220624-7e0fe6dd.pth'  # noqa
model = dict(
    data_preprocessor=data_preprocessor,
    backbone=dict(init_cfg=dict(type='Pretrained', checkpoint=checkpoint)),
    sensor_size=(256, 128),
    original_size=(2048, 1024),
    #test_cfg=dict(mode='slide',  stride=(768, 768))
    )

optim_wrapper = dict(
    _delete_=True,
    type='OptimWrapper',
    optimizer=dict(
        type='AdamW', lr=0.00006, betas=(0.9, 0.999), weight_decay=0.01),
    paramwise_cfg=dict(
        custom_keys={
            'pos_block': dict(decay_mult=0.),
            'norm': dict(decay_mult=0.),
            'head': dict(lr_mult=10.)
        }))

param_scheduler = [
    dict(
        type='LinearLR', start_factor=1e-6, by_epoch=False, begin=0, end=1500),
    dict(
        type='PolyLR',
        eta_min=0.0,
        power=1.0,
        begin=1500,
        end=160000,
        by_epoch=False,
    )
]

train_dataloader = dict(batch_size=4, num_workers=6)
val_dataloader = dict(batch_size=4, num_workers=6)
test_dataloader = val_dataloader
