import argparse
import numpy as np
import imageio
import os

parser = argparse.ArgumentParser("Converts a nested folder of segmentation label images to color images (overwrites the images)")

parser.add_argument("path", type=str)

# id is list index
trainId_to_color = [
    np.array([128, 64,128]),
    np.array([244, 35,232]),
    np.array([ 70, 70, 70]),
    np.array([102,102,156]),
    np.array([190,153,153]),
    np.array([153,153,153]),
    np.array([250,170, 30]),
    np.array([220,220,  0]),
    np.array([107,142, 35]),
    np.array([152,251,152]),
    np.array([ 70,130,180]),
    np.array([220, 20, 60]),
    np.array([255,  0,  0]),
    np.array([  0,  0,142]),
    np.array([  0,  0, 70]),
    np.array([  0, 60,100]),
    np.array([  0, 80,100]),
    np.array([  0,  0,230]),
    np.array([119, 11, 32]),
    np.array([  0,  0,142]),
]

def translate(id):
    return trainId_to_color[id]

def main(args):
    fn = np.vectorize(translate, signature="()->(n)")

    for subdir, _, files in os.walk(args.path):
        for file in files:
            path = os.path.join(subdir, file)
            extension = path.split(".")[1]
            if extension not in ["png", "jpg", "jpeg"]:
                continue
            print(path)
            img = imageio.imread(path)
            img = fn(img)
            imageio.imwrite(f"{path.split('.')[0]}.color.{extension}", img.astype(np.uint8))

if __name__ == '__main__':
    args = parser.parse_args()
    main(args)
