#!/bin/sh

## uncomment for slurm
##SBATCH -p gpu
##SBATCH --gres=gpu:1
##SBATCH -c 10

export PYTHONPATH=./:./PixelDiff
eval "$(conda shell.bash hook)"
conda activate l2s  # pytorch 1.4.0 env
PYTHON=python

dataset=$1
exp_name=$2
exp_dir=exp/${dataset}/${exp_name}
result_dir=${exp_dir}/result
config=config/${dataset}/${dataset}_${exp_name}.yaml
now=$(date +"%Y%m%d_%H%M%S")

mkdir -p ${result_dir}
cp tool/oracle.sh tool/oracle.py ${config} ${exp_dir}

export PYTHONPATH=./:./PixelDiff
$PYTHON -u ${exp_dir}/oracle.py \
  --config=${config} \
  2>&1 | tee ${result_dir}/oracle-$now.log
