# max return in respective dataset * 2
MT50_targets = {
    'assembly-v1': 1450286.625, 'button-press-v1': 566043.703125, 'disassemble-v1': -9.405543645222982,
    'plate-slide-side-v1': 374616.09375, 'door-lock-v1': 544039.125, 'door-unlock-v1': 501917.859375,
    'pick-place-v1': 477427.6875, 'drawer-close-v1': 521100.375, 'coffee-pull-v1': 520720.3125,
    'handle-pull-v1': 493718.203125, 'peg-insert-side-v1': 307802.578125, 'door-close-v1': 578117.109375,
    'button-press-topdown-v1': 522984.65625, 'lever-pull-v1': -1.220013936360677, 'reach-v1': 638514.28125,
    'door-open-v1': 501558.234375, 'sweep-v1': 122089.7578125, 'box-close-v1': 589573.546875,
    'button-press-wall-v1': 537146.484375, 'basketball-v1': 500070.1875, 'soccer-v1': 514502.15625,
    'handle-press-v1': 493111.78125, 'coffee-button-v1': 552852.75, 'faucet-open-v1': 154400.8125,
    'plate-slide-v1': 339928.546875, 'reach-wall-v1': 626686.5, 'handle-pull-side-v1': 453395.90625,
    'drawer-open-v1': 488456.0625, 'dial-turn-v1': 450512.625, 'sweep-into-v1': 536743.265625,
    'bin-picking-v1': 687246.1875, 'coffee-push-v1': 534557.34375, 'pick-out-of-hole-v1': -11.327592213948568,
    'button-press-topdown-wall-v1': 522397.078125, 'plate-slide-back-side-v1': 530872.96875,
    'plate-slide-back-v1': 532280.8125, 'stick-push-v1': 178049.05078125, 'hand-insert-v1': 585300.9375,
    'window-open-v1': 356100.890625, 'pick-place-wall-v1': 506045.0625, 'hammer-v1': 324996.609375,
    'peg-unplug-side-v1': 549168.65625, 'window-close-v1': 293120.0390625, 'faucet-close-v1': 333695.90625,
    'handle-press-side-v1': 472267.875, 'push-back-v1': 519344.109375, 'push-v1': 539754.421875,
    'push-wall-v1': 522941.578125, 'stick-pull-v1': 1216821.9375, 'shelf-place-v1': 319610.765625
}

MT50_targets_v2 = {
    'assembly-v2': 1285.642, 'button-press-v2': 1604.5227, 'disassemble-v2': 1536.4567,
    'plate-slide-side-v2': 1748.304, 'door-lock-v2': 1831.5373, 'door-unlock-v2': 1794.7213,
    'pick-place-v2': 1300.692, 'drawer-close-v2': 1880.0, 'coffee-pull-v2': 1475.0727,
    'handle-pull-v2': 1759.07, 'peg-insert-side-v2': 1695.9867, 'door-close-v2': 1587.8,
    'button-press-topdown-v2': 1384.7, 'lever-pull-v2': 1677.1973, 'reach-v2': 1905.1067,
    'door-open-v2': 1608.812, 'sweep-v2': 1560.82, 'box-close-v2': 1127.9013,
    'button-press-wall-v2': 1614.572, 'basketball-v2': 1597.018, 'soccer-v2': 1706.2247,
    'handle-press-v2': 1929.8347, 'coffee-button-v2': 1698.32, 'faucet-open-v2': 1783.7487,
    'plate-slide-v2': 1713.0807, 'reach-wall-v2': 1863.1053, 'handle-pull-side-v2': 1710.8367,
    'drawer-open-v2': 1762.81, 'dial-turn-v2': 1887.328, 'sweep-into-v2': 1815.9427,
    'bin-picking-v2': 1308.598, 'coffee-push-v2': 1694.6847, 'pick-out-of-hole-v2': 1588.1173,
    'button-press-topdown-wall-v2': 1388.598, 'plate-slide-back-side-v2': 1833.7033,
    'plate-slide-back-v2': 1806.1567, 'stick-push-v2': 1629.2633, 'hand-insert-v2': 1789.0467,
    'window-open-v2': 1717.4207, 'pick-place-wall-v2': 1654.644, 'hammer-v2': 1724.842,
    'peg-unplug-side-v2': 1619.82, 'window-close-v2': 1559.3093, 'faucet-close-v2': 1798.588,
    'handle-press-side-v2': 1897.76, 'push-back-v2': 1564.7233, 'push-v2': 1791.2247,
    'push-wall-v2': 1746.7047, 'stick-pull-v2': 1551.368, 'shelf-place-v2': 1513.3307
}

MT50_v2_500steps_targets = {
    'assembly-v2_500': 4557.758, 'button-press-v2_500': 3718.285, 'disassemble-v2_500': 4557.419,
    'plate-slide-side-v2_500': 4734.194, 'door-lock-v2_500': 4715.318, 'door-unlock-v2_500': 4739.971,
    'pick-place-v2_500': 2967.195, 'drawer-close-v2_500': 4880.49, 'coffee-pull-v2_500': 515.462, 
    'handle-pull-v2_500': 4771.349, 'peg-insert-side-v2_500': 4690.355, 'door-close-v2_500': 4592.562, 
    'button-press-topdown-v2_500': 3925.996, 'lever-pull-v2_500': 4215.64, 'reach-v2_500': 4899.213, 
    'door-open-v2_500': 4623.019, 'sweep-v2_500': 4578.873, 'box-close-v2_500': 4502.542, 
    'button-press-wall-v2_500': 4350.583, 'basketball-v2_500': 393.772, 'soccer-v2_500': 3463.242, 
    'handle-press-v2_500': 4928.883, 'coffee-button-v2_500': 4492.226, 'faucet-open-v2_500': 4776.849, 
    'plate-slide-v2_500': 4697.033, 'reach-wall-v2_500': 4856.4, 'handle-pull-side-v2_500': 4700.831,
    'drawer-open-v2_500': 4791.439, 'dial-turn-v2_500': 4750.286, 'sweep-into-v2_500': 4763.013, 
    'bin-picking-v2_500': 1199.102, 'coffee-push-v2_500': 4525.045, 'pick-out-of-hole-v2_500': 565.242, 
    'button-press-topdown-wall-v2_500': 3920.311, 'plate-slide-back-side-v2_500': 4834.989,
    'plate-slide-back-v2_500': 4790.534, 'stick-push-v2_500': 4557.222, 'hand-insert-v2_500': 4792.846, 
    'window-open-v2_500': 4550.688, 'pick-place-wall-v2_500': 78.686, 'hammer-v2_500': 4702.326, 
    'peg-unplug-side-v2_500': 4701.794, 'window-close-v2_500': 4643.951, 'faucet-close-v2_500': 4785.459, 
    'handle-press-side-v2_500': 4893.379, 'push-back-v2_500': 4578.973, 'push-v2_500': 4700.407,
    'push-wall-v2_500': 4716.214, 'stick-pull-v2_500': 4519.777, 'shelf-place-v2_500': 1137.201
}


ATARI_targets = {
    'AlienNoFrameskip-v4': 218.0, 'AmidarNoFrameskip-v4': 204.0, 'AssaultNoFrameskip-v4': 160.0,
    'AsterixNoFrameskip-v4': 104.0, 'AtlantisNoFrameskip-v4': 1444.0, 'BankHeistNoFrameskip-v4': 86.0, 
    'BattleZoneNoFrameskip-v4': 32.0, 'BeamRiderNoFrameskip-v4': 152.0, 'BoxingNoFrameskip-v4': 88.0, 
    'BreakoutNoFrameskip-v4': 95.0, 'CarnivalNoFrameskip-v4': 45.0, 'CentipedeNoFrameskip-v4': 137.0, 
    'ChopperCommandNoFrameskip-v4': 70.0, 'CrazyClimberNoFrameskip-v4': 735.0, 'DemonAttackNoFrameskip-v4': 231.0, 
    'DoubleDunkNoFrameskip-v4': 14.0, 'EnduroNoFrameskip-v4': 1091.0, 'FishingDerbyNoFrameskip-v4': 53.0,
    'FreewayNoFrameskip-v4': 34.0, 'FrostbiteNoFrameskip-v4': 71.0, 'GopherNoFrameskip-v4': 627.0, 
    'GravitarNoFrameskip-v4': 6.0, 'HeroNoFrameskip-v4': 201.0, 'IceHockeyNoFrameskip-v4': 2.0,
    'JamesbondNoFrameskip-v4': 17.0, 'KangarooNoFrameskip-v4': 74.0, 'KrullNoFrameskip-v4': 741.0,
    'KungFuMasterNoFrameskip-v4': 275.0, 'MsPacmanNoFrameskip-v4': 403.0, 'NameThisGameNoFrameskip-v4': 640.0, 
    'PhoenixNoFrameskip-v4': 67.0, 'PongNoFrameskip-v4': 21.0, 'PooyanNoFrameskip-v4': 427.0,
    'QbertNoFrameskip-v4': 588.0, 'RiverraidNoFrameskip-v4': 250.0, 'RoadRunnerNoFrameskip-v4': 217.0, 
    'RobotankNoFrameskip-v4': 73.0, 'SeaquestNoFrameskip-v4': 315.0, 'SpaceInvadersNoFrameskip-v4': 318.0, 
    'StarGunnerNoFrameskip-v4': 261.0, 'TimePilotNoFrameskip-v4': 24.0, 'UpNDownNoFrameskip-v4': 246.0, 
    'VideoPinballNoFrameskip-v4': 1078.0, 'WizardOfWorNoFrameskip-v4': 46.0, 
    'YarsRevengeNoFrameskip-v4': 207.0, 'ZaxxonNoFrameskip-v4': 30.0
}

# unfortunately DMControl produces these wird environment names
DMCONTROL_targets = {
    'acrobot-swingup': 158.764,
    'ball_in_cup-catch': 1000.0,
    'cartpole-balance': 993.194, 
    'cartpole-swingup': 857.492,
    'cheetah-run': 451.274,
    'finger-spin': 987.0, 
    'finger-turn_easy': 1000.0,
    'finger-turn_hard': 1000.0, 
    'fish-swim': 794.356, 
    'fish-upright': 999.433, 
    'hopper-hop': 116.777, 
    'hopper-stand': 975.575,
    'humanoid-run': 2.567, 
    'humanoid-stand': 17.218, 
    'humanoid-walk': 12.589, 
    'manipulator-bring_ball': 19.022, 
    'manipulator-insert_ball': 1000.0,
    'manipulator-insert_peg': 1000.0,
    'pendulum-swingup': 1000.0, 
    'point_mass-easy': 998.373,
    'reacher-easy': 1000.0, 
    'reacher-hard': 1000.0,
    'swimmer-swimmer15': 1000.0, 
    'swimmer-swimmer6': 1000.0,
    'walker-run': 513.464, 
    'walker-stand': 999.82,
    'walker-walk': 982.159
}


DARK_ROOM = {
    "MiniHack-Room-Dark-10x10-v0": 1,
    "MiniHack-Room-Dark-Dense-10x10-v0": 82,
    "MiniHack-Room-Dark-Sparse-10x10-v0": 1,
    "MiniHack-Room-Dark-17x17-v0": 1,
    "MiniHack-Room-Dark-Dense-17x17-v0": 82,
    "MiniHack-Room-Dark-Sparse-17x17-v0": 1,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(2,0)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(0,2)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(1,5)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(2,2)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(5,7)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(9,1)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(6,9)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(5,5)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(1,1)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(7,9)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(0,9)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(3,8)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(8,5)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(0,0)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(8,9)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(1,3)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(0,5)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(0,1)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(9,5)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(8,3)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(4,4)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(1,2)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(7,8)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(9,4)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(3,7)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(9,2)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(9,7)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(5,6)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(6,3)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(4,6)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(0,8)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(3,3)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(4,5)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(1,9)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(1,4)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(9,3)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(7,3)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(3,9)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(2,4)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(0,6)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(6,2)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(2,3)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(1,8)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(4,2)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(8,0)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(8,6)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(3,1)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(6,7)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(2,7)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(1,0)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(4,0)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(7,0)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(9,6)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(8,8)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(2,6)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(5,4)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(7,1)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(2,9)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(2,5)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(4,3)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(4,1)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(7,2)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(0,3)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(8,1)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(5,3)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(7,7)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(6,1)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(0,7)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(2,8)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(9,9)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(5,2)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(4,8)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(8,2)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(6,0)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(7,4)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(3,2)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(4,7)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(7,6)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(3,6)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(0,4)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(9,0)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(8,4)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(3,4)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(6,5)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(7,5)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(5,0)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(3,5)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(9,8)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(8,7)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(3,0)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(6,6)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(5,9)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(1,7)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(5,1)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(1,6)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(5,8)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(2,1)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(4,9)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(6,4)": 82,
    "MiniHack-Room-Dark-Dense-10x10-v0_(0,0)_(6,8)": 82,
}

GYM_MUJOCO_targets = {
    "HalfCheetah-v3": 6000.0,
    "Hopper-v3": 3600.0,
    "Walker2d-v3": 5000.0,
    "HalfCheetah-v2": 6000.0,
    "Hopper-v2": 3600.0,
    "Walker2d-v2": 5000.0,
}

PROCGEN_targets = {
    "bigfish": 40.0,
    "bossfight": 15.0,
    "caveflyer": 13.0,
    "chaser": 13.3128,
    "climber": 16.0,
    "coinrun": 10.0,
    "dodgeball": 20.0,
    "fruitbot": 38.0,
    "heist": 10.0,
    "jumper": 10.0,
    "leaper": 10.0,
    "maze": 10.0,
    "miner": 13.0,
    "ninja": 10.0,
    "plunder": 18.0,
    "starpilot": 67.0,
}

COMPOSUITE_targets = {
    "Panda_Hollowbox_ObjectDoor_Push": 322.4837,
    "Panda_Box_ObjectDoor_PickPlace": 329.0957,
    "Panda_Plate_ObjectDoor_Push": 307.8281,
    "Panda_Plate_GoalWall_Push": 348.3908,
    "Kinova3_Box_ObjectWall_Trashcan": 395.7307,
    "Panda_Plate_GoalWall_PickPlace": 377.3351,
    "Jaco_Dumbbell_None_PickPlace": 355.6125,
    "Kinova3_Dumbbell_None_Push": 405.8568,
    "Panda_Plate_GoalWall_Trashcan": 367.3199,
    "Jaco_Hollowbox_ObjectDoor_PickPlace": 356.0208,
    "Jaco_Box_ObjectDoor_PickPlace": 366.4434,
    "Panda_Dumbbell_None_Trashcan": 372.779,
    "IIWA_Box_None_Push": 423.2112,
    "Jaco_Plate_GoalWall_Push": 327.3481,
    "Jaco_Plate_ObjectWall_PickPlace": 355.2842,
    "IIWA_Hollowbox_ObjectDoor_Push": 381.1122,
    "Jaco_Plate_ObjectWall_Shelf": 319.127,
    "Panda_Box_None_Trashcan": 392.7072,
    "Panda_Hollowbox_GoalWall_PickPlace": 389.1634,
    "Kinova3_Box_None_PickPlace": 425.4009,
    "Jaco_Box_ObjectDoor_Shelf": 330.9081,
    "IIWA_Box_GoalWall_PickPlace": 417.9734,
    "Kinova3_Dumbbell_None_Trashcan": 390.6068,
    "Kinova3_Dumbbell_ObjectWall_Trashcan": 373.2451,
    "IIWA_Plate_None_Trashcan": 397.7719,
    "Jaco_Box_ObjectDoor_Push": 361.8412,
    "IIWA_Box_None_Trashcan": 414.214,
    "Kinova3_Box_ObjectDoor_PickPlace": 408.9602,
    "IIWA_Plate_None_Shelf": 374.8415,
    "Panda_Hollowbox_ObjectDoor_Shelf": 312.36,
    "Kinova3_Hollowbox_GoalWall_Push": 369.8759,
    "Jaco_Box_None_Push": 386.1124,
    "Panda_Dumbbell_ObjectDoor_PickPlace": 303.0532,
    "Jaco_Box_GoalWall_Trashcan": 369.816,
    "Jaco_Hollowbox_None_PickPlace": 378.2476,
    "Jaco_Box_ObjectWall_Shelf": 330.0855,
    "Jaco_Dumbbell_None_Push": 356.8932,
    "Panda_Dumbbell_ObjectDoor_Push": 309.5276,
    "Jaco_Dumbbell_ObjectDoor_Trashcan": 325.079,
    "Jaco_Hollowbox_None_Trashcan": 362.976,
    "Jaco_Hollowbox_ObjectWall_Push": 360.565,
    "Jaco_Hollowbox_ObjectWall_Trashcan": 342.2538,
    "Jaco_Box_GoalWall_Push": 321.1584,
    "Panda_Plate_None_PickPlace": 380.8439,
    "IIWA_Hollowbox_GoalWall_PickPlace": 419.541,
    "Panda_Box_None_Push": 397.4014,
    "Panda_Hollowbox_ObjectWall_Shelf": 289.9606,
    "IIWA_Plate_ObjectWall_Push": 395.6757,
    "IIWA_Dumbbell_ObjectDoor_Shelf": 332.6358,
    "Panda_Dumbbell_ObjectWall_PickPlace": 313.7836,
    "Panda_Hollowbox_ObjectWall_Push": 330.8746,
    "Panda_Plate_ObjectDoor_Trashcan": 293.2389,
    "Panda_Plate_None_Trashcan": 367.6216,
    "Panda_Dumbbell_None_PickPlace": 373.9502,
    "Kinova3_Dumbbell_GoalWall_Trashcan": 386.5341,
    "Panda_Hollowbox_None_Shelf": 349.8202,
    "Panda_Hollowbox_None_Push": 399.9587,
    "IIWA_Hollowbox_ObjectWall_PickPlace": 406.4884,
    "Kinova3_Dumbbell_ObjectWall_PickPlace": 388.9163,
    "Panda_Dumbbell_GoalWall_Trashcan": 357.7439,
    "Jaco_Hollowbox_ObjectDoor_Shelf": 318.0287,
    "IIWA_Plate_ObjectDoor_Push": 373.6541,
    "Jaco_Plate_GoalWall_Shelf": 334.1012,
    "Panda_Dumbbell_ObjectDoor_Trashcan": 284.3753,
    "IIWA_Hollowbox_ObjectDoor_PickPlace": 386.7481,
    "Panda_Box_GoalWall_Shelf": 352.3642,
    "IIWA_Hollowbox_ObjectWall_Push": 400.5991,
    "IIWA_Plate_GoalWall_PickPlace": 408.5447,
    "Kinova3_Plate_ObjectWall_Trashcan": 382.8602,
    "Panda_Plate_GoalWall_Shelf": 340.3288,
    "Panda_Plate_ObjectWall_Trashcan": 303.8733,
    "Jaco_Dumbbell_None_Trashcan": 341.4949,
    "Panda_Plate_ObjectWall_Shelf": 277.7495,
    "Jaco_Plate_ObjectDoor_Shelf": 323.689,
    "IIWA_Plate_ObjectWall_Trashcan": 379.8558,
    "Kinova3_Hollowbox_ObjectWall_Push": 397.4564,
    "Jaco_Dumbbell_None_Shelf": 325.7801,
    "Kinova3_Box_None_Push": 428.0315,
    "Kinova3_Plate_ObjectWall_Shelf": 370.975,
    "IIWA_Plate_ObjectDoor_Shelf": 349.4955,
    "Panda_Box_ObjectDoor_Shelf": 300.808,
    "IIWA_Plate_ObjectDoor_PickPlace": 381.6441,
    "Kinova3_Plate_GoalWall_Shelf": 373.31,
    "Panda_Dumbbell_None_Push": 373.3488,
    "Kinova3_Hollowbox_ObjectWall_Trashcan": 379.6972,
    "Jaco_Plate_ObjectDoor_Trashcan": 337.2096,
    "Panda_Hollowbox_ObjectWall_PickPlace": 345.2379,
    "Panda_Hollowbox_None_Trashcan": 382.1819,
    "Panda_Box_ObjectWall_Push": 330.4575,
    "Jaco_Box_None_Shelf": 348.9094,
    "Kinova3_Plate_GoalWall_PickPlace": 406.7204,
    "Panda_Box_ObjectWall_PickPlace": 338.1854,
    "Panda_Box_GoalWall_Trashcan": 392.5051,
    "Kinova3_Hollowbox_GoalWall_PickPlace": 413.5353,
    "IIWA_Plate_None_PickPlace": 414.3734,
    "IIWA_Box_GoalWall_Trashcan": 411.6396,
    "Panda_Dumbbell_GoalWall_Shelf": 324.7186,
    "IIWA_Dumbbell_ObjectDoor_Push": 372.8149,
    "Panda_Box_ObjectWall_Shelf": 297.7375,
    "IIWA_Plate_GoalWall_Trashcan": 400.2317,
    "IIWA_Plate_ObjectWall_Shelf": 351.4135,
    "Jaco_Box_None_Trashcan": 377.2025,
    "Jaco_Plate_GoalWall_Trashcan": 347.8802,
    "IIWA_Dumbbell_GoalWall_Trashcan": 384.8889,
    "Kinova3_Plate_ObjectWall_PickPlace": 398.0574,
    "Kinova3_Plate_None_Push": 407.4045,
    "Panda_Hollowbox_ObjectWall_Trashcan": 331.1017,
    "Panda_Dumbbell_ObjectWall_Shelf": 280.836,
    "Kinova3_Hollowbox_GoalWall_Shelf": 404.2996,
    "IIWA_Plate_GoalWall_Shelf": 372.4099,
    "Panda_Dumbbell_None_Shelf": 329.6797,
    "Jaco_Hollowbox_GoalWall_PickPlace": 362.3539,
    "Jaco_Dumbbell_ObjectWall_Trashcan": 325.5367,
    "IIWA_Box_None_PickPlace": 422.6896,
    "IIWA_Box_ObjectWall_Shelf": 369.3631,
    "IIWA_Box_GoalWall_Push": 372.0507,
    "Panda_Box_ObjectDoor_Trashcan": 315.0218,
    "Panda_Hollowbox_GoalWall_Trashcan": 378.0457,
    "Jaco_Box_GoalWall_PickPlace": 372.9176,
    "Jaco_Dumbbell_GoalWall_PickPlace": 348.9397,
    "Kinova3_Dumbbell_GoalWall_Shelf": 355.2201,
    "Kinova3_Box_GoalWall_Trashcan": 409.4071,
    "IIWA_Plate_ObjectWall_PickPlace": 396.0394,
    "Panda_Plate_None_Shelf": 341.5723,
    "Jaco_Box_ObjectWall_Trashcan": 350.9608,
    "Jaco_Box_ObjectWall_PickPlace": 371.855,
    "Kinova3_Plate_ObjectDoor_Push": 393.791,
    "Kinova3_Box_None_Shelf": 389.364,
    "Kinova3_Plate_ObjectWall_Push": 394.4429,
    "IIWA_Dumbbell_ObjectWall_Trashcan": 365.8652,
    "Kinova3_Box_GoalWall_Push": 373.9586,
    "IIWA_Box_ObjectWall_Trashcan": 394.6256,
    "IIWA_Box_ObjectDoor_Trashcan": 377.3615,
    "Jaco_Hollowbox_None_Shelf": 346.1891,
    "Kinova3_Dumbbell_GoalWall_PickPlace": 393.442,
    "Kinova3_Dumbbell_None_PickPlace": 401.8801,
    "Panda_Hollowbox_GoalWall_Push": 360.0789,
    "IIWA_Hollowbox_ObjectDoor_Shelf": 343.6018,
    "Kinova3_Dumbbell_ObjectDoor_Trashcan": 372.15,
    "IIWA_Hollowbox_GoalWall_Shelf": 403.9416,
    "Kinova3_Plate_None_Trashcan": 395.1252,
    "IIWA_Dumbbell_None_Push": 403.705,
    "Jaco_Hollowbox_ObjectDoor_Trashcan": 337.9608,
    "IIWA_Dumbbell_GoalWall_Shelf": 358.069,
    "Jaco_Dumbbell_ObjectDoor_PickPlace": 348.8272,
    "IIWA_Dumbbell_None_PickPlace": 408.9983,
    "IIWA_Hollowbox_ObjectWall_Shelf": 364.1277,
    "Jaco_Box_ObjectWall_Push": 369.6819,
    "Kinova3_Dumbbell_ObjectDoor_PickPlace": 383.0844,
    "Kinova3_Hollowbox_ObjectDoor_Shelf": 350.2031,
    "Kinova3_Dumbbell_GoalWall_Push": 355.5746,
    "IIWA_Hollowbox_None_Shelf": 403.8859,
    "Jaco_Plate_None_Push": 367.8203,
    "Kinova3_Dumbbell_ObjectDoor_Shelf": 339.1107,
    "Kinova3_Plate_None_PickPlace": 411.8783,
    "Kinova3_Box_ObjectDoor_Push": 396.5578,
    "Kinova3_Dumbbell_ObjectWall_Push": 386.0225,
    "Kinova3_Box_ObjectDoor_Shelf": 366.5801,
    "IIWA_Dumbbell_None_Trashcan": 389.3736,
    "Jaco_Hollowbox_ObjectDoor_Push": 353.3318,
    "Kinova3_Box_None_Trashcan": 415.2254,
    "Jaco_Plate_GoalWall_PickPlace": 358.3443,
    "Kinova3_Hollowbox_None_Push": 418.2462,
    "IIWA_Box_ObjectWall_Push": 402.1152,
    "Panda_Box_GoalWall_PickPlace": 391.9168,
    "IIWA_Dumbbell_ObjectWall_Push": 389.1574,
    "Panda_Box_ObjectWall_Trashcan": 323.1698,
    "Jaco_Hollowbox_ObjectWall_Shelf": 321.8891,
    "Jaco_Plate_ObjectWall_Trashcan": 334.6109,
    "Kinova3_Hollowbox_ObjectDoor_PickPlace": 396.7687,
    "Kinova3_Hollowbox_ObjectDoor_Push": 398.4861,
    "IIWA_Plate_GoalWall_Push": 376.582,
    "Kinova3_Plate_GoalWall_Push": 369.438,
    "Kinova3_Plate_ObjectDoor_Trashcan": 378.2037,
    "Jaco_Box_GoalWall_Shelf": 348.0137,
    "Kinova3_Plate_None_Shelf": 376.0602,
    "Jaco_Box_ObjectDoor_Trashcan": 348.2585,
    "IIWA_Plate_None_Push": 407.4024,
    "Jaco_Box_None_PickPlace": 380.3599,
    "Kinova3_Plate_ObjectDoor_PickPlace": 396.2977,
    "IIWA_Box_ObjectDoor_Shelf": 355.1942,
    "Panda_Box_None_Shelf": 357.7363,
    "IIWA_Dumbbell_ObjectWall_Shelf": 341.2852,
    "Kinova3_Hollowbox_None_PickPlace": 422.8646,
    "Kinova3_Hollowbox_ObjectWall_Shelf": 375.4196,
    "Jaco_Dumbbell_GoalWall_Push": 295.2301,
    "Kinova3_Plate_GoalWall_Trashcan": 399.722,
    "Panda_Box_GoalWall_Push": 300.7138,
    "Kinova3_Box_ObjectWall_PickPlace": 413.1352,
    "Panda_Plate_ObjectDoor_PickPlace": 314.5126,
    "Jaco_Hollowbox_GoalWall_Shelf": 339.0533,
    "Panda_Box_None_PickPlace": 402.7562,
    "Kinova3_Dumbbell_None_Shelf": 363.8753,
    "Jaco_Plate_ObjectDoor_PickPlace": 353.0497,
    "Panda_Hollowbox_GoalWall_Shelf": 348.1734,
    "Jaco_Hollowbox_GoalWall_Trashcan": 355.6227,
    "Jaco_Hollowbox_GoalWall_Push": 322.2183,
    "Jaco_Dumbbell_GoalWall_Shelf": 322.3699,
    "Kinova3_Box_ObjectWall_Push": 405.5613,
    "Jaco_Dumbbell_ObjectDoor_Shelf": 304.0632,
    "IIWA_Hollowbox_ObjectWall_Trashcan": 390.5933,
    "IIWA_Box_ObjectDoor_PickPlace": 392.528,
    "Jaco_Plate_None_PickPlace": 366.7162,
    "Jaco_Hollowbox_ObjectWall_PickPlace": 363.9757,
    "IIWA_Hollowbox_None_PickPlace": 422.507,
    "IIWA_Dumbbell_ObjectWall_PickPlace": 391.7573,
    "Kinova3_Dumbbell_ObjectDoor_Push": 383.6134,
    "IIWA_Hollowbox_None_Trashcan": 413.8112,
    "IIWA_Box_ObjectWall_PickPlace": 407.7422,
    "Jaco_Dumbbell_GoalWall_Trashcan": 339.696,
    "IIWA_Box_GoalWall_Shelf": 388.9835,
    "IIWA_Hollowbox_None_Push": 420.6052,
    "IIWA_Box_None_Shelf": 392.7056,
    "Kinova3_Hollowbox_GoalWall_Trashcan": 396.6298,
    "Panda_Dumbbell_ObjectWall_Push": 320.4766,
    "IIWA_Dumbbell_ObjectDoor_PickPlace": 375.7194,
    "IIWA_Hollowbox_GoalWall_Push": 378.3529,
    "Jaco_Plate_ObjectDoor_Push": 341.8283,
    "Panda_Dumbbell_ObjectWall_Trashcan": 294.1954,
    "Kinova3_Box_GoalWall_PickPlace": 415.1603,
    "Panda_Dumbbell_GoalWall_PickPlace": 360.2449,
    "Panda_Box_ObjectDoor_Push": 328.241,
    "Jaco_Dumbbell_ObjectDoor_Push": 340.2007,
    "Jaco_Dumbbell_ObjectWall_Push": 337.6736,
    "Panda_Hollowbox_ObjectDoor_PickPlace": 329.384,
    "IIWA_Dumbbell_GoalWall_Push": 358.6089,
    "Jaco_Plate_ObjectWall_Push": 348.5868,
    "IIWA_Hollowbox_GoalWall_Trashcan": 403.7551,
    "IIWA_Dumbbell_GoalWall_PickPlace": 398.5261,
    "Kinova3_Hollowbox_ObjectDoor_Trashcan": 379.065,
    "Jaco_Hollowbox_None_Push": 381.7607,
    "Kinova3_Box_ObjectWall_Shelf": 366.0194,
    "IIWA_Dumbbell_None_Shelf": 360.1213,
    "Kinova3_Hollowbox_ObjectWall_PickPlace": 402.5087,
    "Jaco_Plate_None_Trashcan": 362.5799,
    "Jaco_Dumbbell_ObjectWall_Shelf": 296.5891,
    "Panda_Plate_ObjectWall_PickPlace": 318.9778,
    "Kinova3_Plate_ObjectDoor_Shelf": 363.9405,
    "Jaco_Dumbbell_ObjectWall_PickPlace": 347.2706,
    "Kinova3_Box_ObjectDoor_Trashcan": 389.944,
    "Kinova3_Box_GoalWall_Shelf": 385.2776,
    "IIWA_Hollowbox_ObjectDoor_Trashcan": 369.7449,
    "Kinova3_Dumbbell_ObjectWall_Shelf": 336.2771,
    "Jaco_Plate_None_Shelf": 342.9441,
    "IIWA_Plate_ObjectDoor_Trashcan": 366.6993,
    "IIWA_Box_ObjectDoor_Push": 387.2439,
    "Kinova3_Hollowbox_None_Shelf": 404.0659,
    "Panda_Plate_None_Push": 385.475,
    "Kinova3_Hollowbox_None_Trashcan": 415.3324,
    "Panda_Hollowbox_ObjectDoor_Trashcan": 308.0545,
    "Panda_Dumbbell_GoalWall_Push": 265.7354,
    "Panda_Dumbbell_ObjectDoor_Shelf": 283.3508,
    "IIWA_Dumbbell_ObjectDoor_Trashcan": 358.2904,
    "Panda_Hollowbox_None_PickPlace": 397.2718,
    "Panda_Plate_ObjectDoor_Shelf": 312.9323,
    "Panda_Plate_ObjectWall_Push": 321.3536,
}
   

MIMICGEN_targets = {
    'CoffeePreparation_D0': 1.0,
    'CoffeePreparation_D1': 1.0,
    'Coffee_D0': 1.0,
    'Coffee_D1': 1.0, 
    'Coffee_D2': 1.0,
    'HammerCleanup_D0': 1.0, 
    'HammerCleanup_D1': 1.0, 
    'Kitchen_D0': 1.0,
    'Kitchen_D1': 1.0,
    'MugCleanup_D0': 1.0,
    'MugCleanup_D1': 1.0, 
    'NutAssembly_D0': 1.0, 
    'PickPlace_D0': 1.0, 
    'Square_D0': 1.0,
    'Square_D1': 1.0,
    'Square_D2': 1.0, 
    'StackThree_D0': 1.0, 
    'StackThree_D1': 1.0,
    'Stack_D0': 1.0, 
    'Stack_D1': 1.0, 
    'Threading_D0': 1.0, 
    'Threading_D1': 1.0, 
    'Threading_D2': 1.0,
    'ThreePieceAssembly_D0': 1.0, 
    'ThreePieceAssembly_D1': 1.0, 
    'ThreePieceAssembly_D2': 1.0
}

for key in list(MIMICGEN_targets.keys()):
    for robot in ["Panda", "Sawyer", "IIWA", "UR5e"]:
        MIMICGEN_targets[f"{robot}_{key}"] = MIMICGEN_targets[key]


ALL_TARGETS = {**MT50_targets, **MT50_targets_v2, **ATARI_targets, **DMCONTROL_targets, **DARK_ROOM,
               **GYM_MUJOCO_targets, **MT50_v2_500steps_targets, **PROCGEN_targets, 
               **COMPOSUITE_targets, **MIMICGEN_targets}
