# Forget-Me-Not: Making Backdoor Hard to be Forgotten in Fine-tuning

This repository contains the code to replicate experiments in our paper **COMBAT: Alternated Training for Effective Clean-Label Backdoor Attack**

# Requirements
Install required Python packages:
```
$ python -m pip install -r requirements.txt
```
# Training backdoor model
Run command
```
$ python fmn_attack.py --dataset <datasetName> --attack_name <attackName> --pc <poisoningRate> --saving_prefix <modelPrefix> 
```
where the parameters are as following:
- `dataset`: `cifar10` | `celeba` | `imagenet10`.
- `attack name`: attack method to run with FMN (`badnets`|`blend`|`l0_inv`|`l2_inv`|`trojaning`|`narcisuss`). 
- `pc`: proportion of training data to be poisoned on a 0-to-1 scale (e.g., `0.05` to poison 5% of training data).
- `saving_prefix`: saving prefix for model's checkpoint (e.g., `blend_fmn`).

The trained checkpoint backdoor model should be saved at the path `backdoor_checkpoints\<modelPrefix>\<datasetName>\<datasetName>_<modelPrefix>.pth.tar.`

Sample run:
```
$ python fmn_attack.py --dataset cifar10 --attack_name blend --pc 0.05 --saving_prefix blend_fmn
```




# Pretrained models
We also provide pretrained checkpoints used in the original paper. The checkpoints could be found [here](https://drive.google.com/drive/folders/1Dbyj3nkZX0Zr34mvsKjsHhptDUmbTnWs?usp=sharing) (anonymously). You can download and put them in this repository for evaluating.


# Defense experiments
We also provide code of defense methods evaluated in the paper inside the folder `fine_tuning` (for super-FT and FT-SAM) and `NAD`.
- **Super-FT**: 
```
$ cd defenses/fine_tuning
$ python super_ft.py --dataset <datasetName> --attack_name <attackName> --saving_prefix <modelPrefix> --result_file <resultFileName>
```
The results will be printed on the screen and written in file `<resultFileName>.txt`.
- **FT-SAM**: Run the command
```
$ cd defenses/fine-tuning
$ python ft_sam.py --dataset <datasetName> --attack_name <attackName> --saving_prefix <modelPrefix> --result_file <resultFileName>
```
The results will be printed on the screen and written in file `<resultFileName>.txt`.
- **NAD**: Run the command
```
$ cd defenses/NAD
$ python train_teacher.py --dataset <datasetName> --attack_name <attackName> --saving_prefix <savingPrefix>
$ python nad.py --dataset <datasetName> --attack_name <attackName> --saving_prefix <savingPrefix> --result_file <resultFileName>
```
The results will be printed on the screen and written in file `<resultFileName>.txt`.
