import subprocess
import time
import psutil
import os
import signal
import sys

# --- SETTINGS ---

JOBS = [
    ("eval_scripts/run_hidden_confounders.sh", "hidden_confounders_100.log"),
    ("eval_scripts/run_discrete_ctfte.sh", "discrete_ctfte_100.log"),
    ("eval_scripts/run_general.sh", "general_100.log"),
]

MAX_CPU = 0.7
MAX_MEM = 0.8
SLEEP_TIME = 5

# --- SCRIPT ---

os.makedirs("logs", exist_ok=True)

running = []
stop_requested = False

def signal_handler(sig, frame):
    global stop_requested
    print("\n[INFO] Ctrl+C detected. No new jobs will be started. Waiting for running jobs to finish...")
    stop_requested = True

signal.signal(signal.SIGINT, signal_handler)
signal.signal(signal.SIGTERM, signal_handler)

while JOBS or running:
    # Remove finished processes
    running = [p for p in running if p.poll() is None]

    # Start new jobs if possible and not stopping
    if JOBS and not stop_requested:
        cpu = psutil.cpu_percent(interval=1) / 100
        mem = psutil.virtual_memory().percent / 100
        if cpu < MAX_CPU and mem < MAX_MEM:
            script_path, log_name = JOBS.pop(0)
            log_path = os.path.join("logs", log_name)
            cmd = f"nohup bash {script_path} > {log_path} 2>&1 &"
            print(f"[INFO] Starting: {cmd}")
            p = subprocess.Popen(cmd, shell=True)
            running.append(p)

    time.sleep(SLEEP_TIME)

print("[INFO] All jobs completed or manager stopped.")
