import numpy as np


def ensure_list(*args):
    """
    Ensures all input arguments are lists.
    If an argument is not a list, it is wrapped in a list.

    Args:
        *args: Arbitrary number of arguments to check.

    Returns:
        A tuple where each argument is a list.
    """
    return tuple(arg if isinstance(arg, list) else [arg] for arg in args)


def broadcast_value_to_batch(value, batch_size):
    """
    Covert scalars and 1D arrays to (batch_size, <previous dimension>)
    """
    # Convert scalars to 1D arrays
    if np.isscalar(value):
        value = np.array([value])  # Convert scalar to 1D array

    # Ensure value is a 1D numpy array
    value = np.asarray(value)
    if value.ndim != 1:
        raise ValueError("Value must be a scalar or a 1D array.")

    # Broadcast to the desired shape
    return np.tile(value, (batch_size, 1))
