import os
import sys
import numpy as np
import random
import torch

# Seed for reproducibility
SEED = 42
random.seed(SEED)
np.random.seed(SEED)
torch.manual_seed(SEED)
torch.cuda.manual_seed_all(SEED)
torch.backends.cudnn.deterministic = True
torch.backends.cudnn.benchmark = False

current_dir = os.path.dirname(os.path.realpath(__file__))
# Get the root directory of the project
project_root = os.path.abspath(
    os.path.join(current_dir, os.pardir, os.pardir, "causal_profiler")
)
# Add the project root directory to the Python path
sys.path.insert(0, project_root)

from scm import SCM
from variable import Variable
from constants import (
    VariableDataType,
    MechanismFamily,
    NoiseDistribution,
    NoiseMode,
    NeuralNetworkType,
)


def set_scalar_value():
    var = Variable(name="test", dimensionality=1)
    # Set an integer value
    var.set_value(5)
    print(repr(var))


def set_variable_value():
    var = Variable(name="test", dimensionality=2)

    # Set a 1D numpy array
    var.set_value(np.array([1.0, 2.0]))
    print(repr(var))
    print(var.value.shape)

    # Set a 2D numpy array
    var.set_value(np.array([[1, 2.0], [1, 4.0]]))
    print(repr(var))
    print(var.value.shape)


if __name__ == "__main__":
    print(
        "1. Set variable to values that are scalar, 1D or 2D - gets padded to (batch_size, dimensionality)"
    )
    set_scalar_value()
    set_variable_value()
