# Lint as: python3
# Copyright 2018 The SPL Authors.
#
# All rights reserved.
#
# This is the code for reproducing results of the paper.
"""Utils to manage registry of different entities."""

_REGISTRIES = {}


def register(registry_name, item_name):
  """Decorator which registers item in the registry.

  Args:
    registry_name: name of the registry
    item_name: name of the item in the registry

  Returns:
    Wrapper which registers item.

  Usage:

    @register('network', 'resnet')
    def make_resnet():
      return ResNet(...)
  """

  def _wrap(f):
    if registry_name not in _REGISTRIES:
      _REGISTRIES[registry_name] = {}
    _REGISTRIES[registry_name][item_name] = f
    return f

  return _wrap


def get_registry(registry_name):
  """Returns registry with given name."""
  return _REGISTRIES[registry_name]
