import pandas as pd

def get_sweep_results(api, sweep_id, project="graph_neural_diffusion/scalable_graff", additional_params=None):
    runs = api.runs(path=project, filters={"sweep": sweep_id})

    return df_from_runs(runs, additional_params)

def df_from_runs(runs, additional_params=None):
    result_list = []
    columns = ["dataset", "conv_type", "undirected", "alpha"]
    columns = columns + additional_params if additional_params else columns
    test_result_keys = ["test_acc_mean", "test_acc_std"]
    val_result_keys = ["val_acc_mean", "val_acc_std"]

    for run in runs:
        if run.state == "finished":
            run_dict = {k: v for k, v in run.config.items() if k in columns}
            test_results = run.history(keys=test_result_keys)
            val_results = run.history(keys=val_result_keys)
            results = {**test_results, **val_results}

            for result_key in test_result_keys + val_result_keys:
                try:
                    run_dict[result_key] = results[result_key].to_numpy()[-1] * 100
                except:
                    run_dict[result_key] = 0

            run_dict["run_name"] = run.name
            run_dict["test_acc"] = f"{run_dict['test_acc_mean']:.2f}+-{run_dict['test_acc_std']:.2f}"

            result_list.append(run_dict)

    return pd.DataFrame.from_records(result_list)   


def get_ablation_df(df):
    datasets = df["dataset"].unique()
    d = {dataset: {} for dataset in datasets}
    for _, row in df.iterrows():
        d[row["dataset"]][row["method"]] = row["test_acc"]

    return pd.DataFrame(data=d)


def get_df_from_experiment_name(api, experiment_name, project="graph_neural_diffusion/scalable_graff"):
    runs = api.runs(path=project, filters={"state": "finished", "config.experiment_name": experiment_name})
    return df_from_runs(runs)