# Edge Directionality Improves Learning on Heterophilic Graphs

## Dependencies
You can set up a conda environment with the required dependencies by running the following commands:
```{bash}
conda create -n directed_gnn python=3.10.8
conda activate directed_gnn
conda install pytorch==1.12.1 cudatoolkit=11.3 -c pytorch
conda install pyg pytorch-sparse -c pyg
pip install torch-geometric-signed-directed==0.22.0
pip install ogb==1.3.5
pip install wandb==0.13.5
pip install pytorch_lightning==1.8.2
pip install gdown==4.5.3
```

## Running the Code
The DirGNN results for Table 3 can be obtained with the following command (varying the dataset):
```{bash}
python -m src.full_batch.run --model gnn --dataset squirrel --use_best_hyperparams --num_runs 10
```

Results for Table 2 for the undirected models can be obtained with the following command (varying the dataset the conv_type):
```{bash}
python -m src.full_batch.run --model gnn --dataset squirrel --num_runs 10 --patience 200 --normalize --direction_ablation --self_loops --undirected --conv_type gcn
```

Results for Table 2 and 4 for DirGNN can be obtained with the following command (varying the dataset the conv_type):
```{bash}
python -m src.full_batch.run --model gnn --dataset squirrel --num_runs 10 --patience 200 --normalize --conv_type dir-gcn --alpha 1
python -m src.full_batch.run --model gnn --dataset squirrel --num_runs 10 --patience 200 --normalize --conv_type dir-gcn --alpha 0
python -m src.full_batch.run --model gnn --dataset squirrel --num_runs 10 --patience 200 --normalize --conv_type dir-gcn --alpha 0.5
```

The synthetic experiment can be run (varying the model) with:
```{bash}
./run_synthetic_experiment sage
```

## Change code for Citeseer-Full and Cora-ML
Note, since PyG loads Citeseer-Full and Cora-ML as undirected by default, it is necessary to change a file in your PyG local installation. In particular, it is necessary to comment the line 
```
edge_index = to_undirected(edge_index, num_nodes=x.size(0))
```
in  /miniconda3/envs/your_env/lib/python3.10/site-packages/torch_geometric/io/npz.py

