
import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns
import numpy as np
from scipy.stats import gaussian_kde



############################# EPS ###############################################################
####### 10nm
eps_10nm = [1.475,2.09]
eff_10nm =[1,1.3,1.7,2.4,2.5]
eps_10nm_samp = [1.475,1.4751/1.3,1.475/1.7,1.475/2.4,1.475/2.5,2.09,2.09/1.3,2.09/1.7,2.09/2.4,2.09/2.5]


fig, axseps = plt.subplots(1, 5, figsize=(20, 4), dpi=300)
labelsizetick=12

sns.histplot(eps_10nm_samp, bins=10, kde=True, stat='density', alpha=0.2, color='r', label='10nm', ax=axseps[0])

axseps[0].set_title('10nm', fontsize=20)
axseps[0].set_xlabel('Energy per Size (kWh/cm2)', fontsize=16) 
axseps[0].set_ylabel('Density', fontsize=16)  
axseps[0].tick_params(axis='x', labelsize=labelsizetick)  
axseps[0].tick_params(axis='y', labelsize=labelsizetick)  



#####5nm
eps_5nm = [2.75,3.18]
eff_5nm =[1,1.2,1.6,1]
eps_5nm_samp = [2.75/1,2.75/1.2,2.75/1.6,2.75/1,3.18/1,3.18/1.2,3.18/1.6,3.18/1]

sns.histplot(eps_5nm_samp, bins=8, kde=True, stat='density', alpha=0.2, color='r', label='5nm', ax=axseps[1])

axseps[1].set_title('5nm', fontsize=20)
axseps[1].set_xlabel('Energy per Size (kWh/cm2)', fontsize=16)  
axseps[1].set_ylabel('Density', fontsize=16)  
axseps[1].tick_params(axis='x', labelsize=labelsizetick)  
axseps[1].tick_params(axis='y', labelsize=labelsizetick)  

#####7nm
eps_7nm = [2.72,2.77,1.52,2.15]
eff_7nm =[1,1.3,1.7,2.4,2.5]
eps_7nm_samp = [2.72/1,2.72/1.3,2.72/1.7,2.72/2.4,2.72/2.5,2.77/1,2.77/1.3,2.77/1.7,2.77/2.4,2.77/2.5]

sns.histplot(eps_7nm_samp, bins=10, kde=True, stat='density', alpha=0.2, color='r', label='5nm', ax=axseps[2])

axseps[2].set_title('7nm', fontsize=20)
axseps[2].set_xlabel('Energy per Size (kWh/cm2)', fontsize=16)  
axseps[2].set_ylabel('Density', fontsize=16)  # 
axseps[2].tick_params(axis='x', labelsize=  labelsizetick)  #
axseps[2].tick_params(axis='y', labelsize=labelsizetick)  # 


#####28nm
eps_28nm = [0.9,1.56]
eff_28nm =[1, 1.75, 2.58, 2.41, 2.75]
eps_28nm_samp = [0.9,0.9/1.75,0.9/2.57,0.9/2.41,0.9/2.75,1.56,1.56/1.75,1.56/2.58,1.56/2.41,1.56/2.75]

sns.histplot(eps_28nm_samp, bins=10, kde=True, stat='density', alpha=0.2, color='r', label='28nm', ax=axseps[3])

axseps[3].set_title('28nm', fontsize=20)
axseps[3].set_xlabel('Energy per Size (kWh/cm2)', fontsize=16)  
axseps[3].set_ylabel('Density', fontsize=16)  
axseps[3].tick_params(axis='x', labelsize=labelsizetick)  
axseps[3].tick_params(axis='y', labelsize=labelsizetick)  



#####14/16nm
eps_14nm = [1.2,1.83]
eff_14nm =[1, 1.7/1.3, 2.8/1.3, 3.2/1.3, 3.3/1.3]
eps_14nm_samp = [1.2,1.2/1.7/1.3,1.2/2.8/1.3,1.2/3.2/1.3,1.2/3.3/1.3,1.83,1.83/1.7/1.3,1.83/2.8/1.3,1.83/3.2/1.3,1.83/3.3/1.3]

# sns.histplot(eps_14nm_samp, bins=10, kde=True, stat='density', alpha=0.2, color='r', label='14/16nm', ax=axseps[4])

# axseps[4].set_title('14/16nm', fontsize=20)
# axseps[4].set_xlabel('Energy per Size (kWh/cm2)', fontsize=16)  
# axseps[4].set_ylabel('Density', fontsize=16)  
# axseps[4].tick_params(axis='x', labelsize=labelsizetick)  
# axseps[4].tick_params(axis='y', labelsize=labelsizetick) 


plt.figure(figsize=(10, 6), dpi=500)

# sns.kdeplot(eps_5nm_samp, label='5nm',clip=(0, np.inf), linestyle='-', linewidth=2,color='r')
# sns.kdeplot(eps_7nm_samp, label='7nm',clip=(0, np.inf) ,linestyle='-', linewidth=2,color='g')
# sns.kdeplot(eps_10nm_samp,  label='10nm',clip=(0, np.inf), linestyle='-', linewidth=2,color='b')
# sns.kdeplot(eps_14nm_samp, label='14/16nm',clip=(0, np.inf), linestyle='-', linewidth=2,color='olive')
# sns.kdeplot(eps_28nm_samp,  label='28nm',clip=(0, np.inf), linestyle='-', linewidth=2,color='black')

kdeeps28 = gaussian_kde(eps_28nm_samp)
kdeeps10 = gaussian_kde(eps_10nm_samp)
kdeeps7 = gaussian_kde(eps_7nm_samp)
kdeeps5 = gaussian_kde(eps_5nm_samp)
kdeeps14 = gaussian_kde(eps_14nm_samp)


sampled_dataeps28 = kdeeps28.resample(size=1000).flatten() 
sampled_dataeps10 = kdeeps10.resample(size=1000).flatten()
sampled_dataeps7 = kdeeps7.resample(size=1000).flatten()
sampled_dataeps5 = kdeeps5.resample(size=1000).flatten()
sampled_dataeps14 = kdeeps14.resample(size=1000).flatten()

sampled_dataeps28 = sampled_dataeps28[sampled_dataeps28 >= 0] 
sampled_dataeps10 = sampled_dataeps10[sampled_dataeps10 >= 0] 
sampled_dataeps7 = sampled_dataeps7[sampled_dataeps7 >= 0] 
sampled_dataeps5 = sampled_dataeps5[sampled_dataeps5 >= 0] 
sampled_dataeps14 = sampled_dataeps14[sampled_dataeps14 >= 0] 



sns.histplot(sampled_dataeps5,kde=True, color='r', stat='density', alpha=0.2,edgecolor=None,label= '5nm')
sns.histplot(sampled_dataeps7,kde=True, color='g', stat='density', alpha=0.2,edgecolor=None,label= '7nm')
sns.histplot(sampled_dataeps10,kde=True, color='b', stat='density', alpha=0.2,edgecolor=None,label= '10nm')
sns.histplot(sampled_dataeps14,kde=True, color='indigo', stat='density', alpha=0.2,edgecolor=None,label= '14nm')
sns.histplot(sampled_dataeps28,kde=True, color='black', stat='density', alpha=0.2,edgecolor=None,label= '28nm')




plt.xlabel('EPS', fontsize=30)
plt.ylabel('Probability density', fontsize=30)


plt.legend(fontsize=25)

plt.xticks(fontsize=25)
plt.yticks(fontsize=25)


plt.tight_layout()
plt.savefig('eps.pdf',dpi=500)