import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns
import numpy as np


df = pd.read_csv('./data/TW_2024_hourly.csv')  
df1 = pd.read_csv('./data/US_2024_hourly.csv')
df2 = pd.read_csv('./data/JP_2024_hourly.csv')  
df3 = pd.read_csv('./data/CN_2024_hourly.csv')  
df4 = pd.read_csv('./data/KR_2024_hourly.csv') 


fig, axes = plt.subplots(1, 5, figsize=(25, 6))


regions = ['Taiwan', 'United States', 'Japan', 'China', 'Korea']


for i, (data, region, ax) in enumerate(zip([df, df1, df2, df3, df4], regions, axes)):

    sns.histplot(data['Carbon intensity'], kde=True, stat='density', 
                 alpha=0.2, label='$CI_l$', color='g', edgecolor='none', ax=ax)
    

    sns.histplot(data['Carbon intensity']/(1-0.5*data['Carbon-free energy percentage (CFE%)']/100), 
                 kde=True, stat='density', 
                 alpha=0.2, label='$CI_{res}$ (50% PPA)', color='b', edgecolor='none', ax=ax)
    
    
    sns.histplot(data['Carbon intensity']/(1-1*data['Carbon-free energy percentage (CFE%)']/100), 
                 kde=True, stat='density', 
                 alpha=0.2, label='$CI_{res}$ (100% PPA)', color='r', edgecolor='none', ax=ax)
    

    ax.set_title(region, fontsize=25)
    ax.set_xlabel('Carbon intensity', fontsize=30)
    ax.set_ylabel('Probability density', fontsize=30)
    

    ax.legend(fontsize=20)
    

    ax.tick_params(axis='both', which='major', labelsize=20)


plt.tight_layout()

plt.savefig('ci_kde_5regions.pdf')
