
import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns
import numpy as np


df = pd.read_csv('./data/TW_2024_hourly.csv')  
dfus = pd.read_csv('./data/US_2024_hourly.csv')


ppa_tsmc= np.array([7.6,9.2,10.4,11.2,14.1])/100 #2020-2024

ppa_amd = ppa_tsmc

ppa_intel = np.array([0.65,0.8,0.73,0.71,0.71,0.82,0.8,0.93]) #2015-2023

ci_ppa_0out = (df['Carbon intensity'].values[:, None] * (1-ppa_tsmc)).flatten()

# ci_ppa_50out = ((df['Carbon intensity']/(1-0.5*df['Carbon-free energy percentage (CFE%)']/100)).values[:, None] * (1-ppa_tsmc)).flatten()


ci_ppa_0out_intel = (dfus['Carbon intensity'].values[:, None] * (1-ppa_intel)).flatten()




plt.figure(figsize=(10, 6),dpi=500)


sns.histplot(df['Carbon intensity'], kde=True, stat='density', 
              alpha=0.2, label='$CI_l$ for TSMC', color='b',edgecolor='none')



sns.histplot(ci_ppa_0out, kde=True, stat='density', 
              alpha=0.6, label='$CI_m$ for TSMC', color='b',edgecolor='none')



sns.histplot(ci_ppa_0out_intel, kde=True, stat='density', 
              alpha=0.2, label='$CI_m$ for Intel', color='r',edgecolor='none')

sns.histplot(dfus['Carbon intensity'], kde=True, stat='density', 
              alpha=0.6, label='$CI_l$ for Intel', color='r',edgecolor='none')




plt.xlabel('Carbon intensity', fontsize=30)
plt.ylabel('Probability density', fontsize=30)


plt.legend(fontsize=25)

plt.xticks(fontsize=25)
plt.yticks(fontsize=25)


plt.tight_layout()
plt.savefig('ci_tsmc_intel.pdf',dpi=500)
